/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.capability.IStorageBlockItemHandler;
import xfacthd.framedblocks.common.capability.StorageBlockItemStackHandler;
import xfacthd.framedblocks.common.menu.FramedStorageMenu;

public class FramedStorageBlockEntity
extends FramedBlockEntity
implements MenuProvider,
Nameable,
Clearable {
    public static final Component TITLE = Utils.translate("title", "framed_secret_storage");
    public static final int SLOTS = 27;
    public static final String INVENTORY_NBT_KEY = "inventory";
    public static final String OVERFLOW_NBT_KEY = "overflow";
    private final StorageBlockItemStackHandler itemHandler = FramedStorageBlockEntity.createItemHandler(this, false);
    private List<ItemStack> overflow = null;
    private Component customName = null;

    public FramedStorageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_SECRET_STORAGE.value(), pos, state);
    }

    protected FramedStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void open(ServerPlayer player) {
        player.openMenu((MenuProvider)this);
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.level().getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            drops.add(stack);
        }
        if (this.overflow != null) {
            drops.addAll(this.overflow);
        }
        return drops;
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.overflow = null;
    }

    public int getAnalogOutputSignal() {
        return FramedStorageBlockEntity.getAnalogOutputSignal(this.itemHandler);
    }

    protected static int getAnalogOutputSignal(IStorageBlockItemHandler itemHandler) {
        int stacks = 0;
        float fullness = 0.0f;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            float sizeLimit = Math.min(itemHandler.getSlotLimit(i), stack.getMaxStackSize());
            fullness += (float)stack.getCount() / sizeLimit;
            ++stacks;
        }
        return Mth.floor((float)((fullness /= (float)itemHandler.getSlots()) * 14.0f)) + (stacks > 0 ? 1 : 0);
    }

    public IStorageBlockItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChangedWithoutSignalUpdate();
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getCustomName() {
        return this.customName;
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put(INVENTORY_NBT_KEY, (Tag)this.itemHandler.serializeNBT(provider));
        if (this.customName != null) {
            nbt.putString("custom_name", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        this.saveOverflow(nbt, provider);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.itemHandler.deserializeNBT(provider, nbt.getCompound(INVENTORY_NBT_KEY));
        this.separateOverflow();
        this.loadOverflow(nbt, provider);
        if (nbt.contains("custom_name", 8)) {
            this.customName = Component.Serializer.fromJson((String)nbt.getString("custom_name"), (HolderLookup.Provider)provider);
        }
    }

    private void separateOverflow() {
        if (this.itemHandler.getSlots() > 27) {
            int i;
            List<ItemStack> stacks = this.itemHandler.getBackingList();
            this.overflow = NonNullList.withSize((int)(stacks.size() - 27), (Object)ItemStack.EMPTY);
            for (i = 27; i < stacks.size(); ++i) {
                this.overflow.set(i - 27, stacks.get(i));
            }
            this.itemHandler.setSize(27);
            for (i = 0; i < 27; ++i) {
                this.itemHandler.setStackInSlot(i, stacks.get(i));
            }
        }
    }

    private void loadOverflow(CompoundTag nbt, HolderLookup.Provider provider) {
        if (nbt.contains(OVERFLOW_NBT_KEY)) {
            ListTag stackList = nbt.getList(OVERFLOW_NBT_KEY, 10);
            this.overflow = NonNullList.withSize((int)stackList.size(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < stackList.size(); ++i) {
                CompoundTag itemTag = stackList.getCompound(i);
                int slot = itemTag.getInt("Slot");
                if (slot < 0 || slot >= this.overflow.size()) continue;
                ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemTag).ifPresent(stack -> this.overflow.set(slot, (ItemStack)stack));
            }
        }
    }

    private void saveOverflow(CompoundTag nbt, HolderLookup.Provider provider) {
        if (this.overflow != null) {
            ListTag stackList = new ListTag();
            for (int i = 0; i < this.overflow.size(); ++i) {
                if (this.overflow.get(i).isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.putInt("Slot", i);
                stackList.add((Object)this.overflow.get(i).save(provider, (Tag)itemTag));
            }
            nbt.put(OVERFLOW_NBT_KEY, (Tag)stackList);
        }
    }

    protected Component getDefaultName() {
        return TITLE;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return FramedStorageMenu.createSingle(windowId, inv, this.itemHandler);
    }

    public static StorageBlockItemStackHandler createItemHandler(@Nullable FramedStorageBlockEntity be, boolean doubleChest) {
        return new StorageBlockItemStackHandler(be, 27 * (doubleChest ? 2 : 1));
    }
}

