/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.diagonalblocks;

import fuzs.diagonalblocks.api.v2.DiagonalBlock;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.pillar.FramedFenceGeometry;

class FramedDiagonalFenceGeometry
extends FramedFenceGeometry {
    private final boolean northEast;
    private final boolean southEast;
    private final boolean northWest;
    private final boolean southWest;

    public FramedDiagonalFenceGeometry(GeometryFactory.Context ctx) {
        super(ctx);
        this.northEast = (Boolean)ctx.state().getValue((Property)DiagonalBlock.NORTH_EAST);
        this.southEast = (Boolean)ctx.state().getValue((Property)DiagonalBlock.SOUTH_EAST);
        this.northWest = (Boolean)ctx.state().getValue((Property)DiagonalBlock.NORTH_WEST);
        this.southWest = (Boolean)ctx.state().getValue((Property)DiagonalBlock.SOUTH_WEST);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        super.transformQuad(quadMap, quad);
        FramedDiagonalFenceGeometry.createDiagonalFenceBars(quadMap, quad, Direction.NORTH, this.northEast);
        FramedDiagonalFenceGeometry.createDiagonalFenceBars(quadMap, quad, Direction.EAST, this.southEast);
        FramedDiagonalFenceGeometry.createDiagonalFenceBars(quadMap, quad, Direction.SOUTH, this.southWest);
        FramedDiagonalFenceGeometry.createDiagonalFenceBars(quadMap, quad, Direction.WEST, this.northWest);
    }

    private static void createDiagonalFenceBars(QuadMap quadMap, BakedQuad quad, Direction dir, boolean active) {
        if (!active) {
            return;
        }
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            QuadModifier mod = QuadModifier.of(quad).apply(Modifiers.cutTopBottom(dir.getOpposite(), 0.4375f)).apply(Modifiers.cutTopBottom(dir.getClockWise(), 0.5625f)).apply(Modifiers.cutTopBottom(dir.getCounterClockWise(), 0.5625f)).apply(FramedDiagonalFenceGeometry.rotate(dir));
            mod.derive().apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.9375f : 0.25f)).export(quadMap.get(null));
            mod.apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.5625f : 0.625f)).export(quadMap.get(null));
        } else if (quadDir == dir.getClockWise() || quadDir == dir.getCounterClockWise()) {
            boolean neg = !Utils.isPositive(dir);
            QuadModifier.of(quad).apply(Modifiers.cutSide(neg ? 0.0f : 0.5625f, 0.375f, neg ? 0.4375f : 1.0f, 0.5625f)).apply(Modifiers.setPosition(0.5625f)).apply(FramedDiagonalFenceGeometry.rotate(dir)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSide(neg ? 0.0f : 0.5625f, 0.75f, neg ? 0.4375f : 1.0f, 0.9375f)).apply(Modifiers.setPosition(0.5625f)).apply(FramedDiagonalFenceGeometry.rotate(dir)).export(quadMap.get(null));
        } else if (quadDir == dir) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.4375f, 0.375f, 0.5625f, 0.5625f)).apply(FramedDiagonalFenceGeometry.rotate(dir)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.4375f, 0.75f, 0.5625f, 0.9375f)).apply(FramedDiagonalFenceGeometry.rotate(dir)).export(quadMap.get(null));
        }
    }

    private static QuadModifier.Modifier rotate(Direction dir) {
        return Modifiers.rotateCentered(Direction.Axis.Y, -45.0f, true, new Vector3f((float)dir.getStepX(), 1.0f, (float)dir.getStepZ()));
    }
}

