/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.diagonalblocks;

import com.google.common.base.Preconditions;
import fuzs.diagonalblocks.api.v2.DiagonalBlock;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.pane.FramedPaneGeometry;

class FramedDiagonalPaneGeometry
extends FramedPaneGeometry {
    private final boolean northEast;
    private final boolean southEast;
    private final boolean northWest;
    private final boolean southWest;
    private final boolean noPillar;

    public FramedDiagonalPaneGeometry(GeometryFactory.Context ctx) {
        super(ctx);
        this.northEast = (Boolean)ctx.state().getValue((Property)DiagonalBlock.NORTH_EAST);
        this.southEast = (Boolean)ctx.state().getValue((Property)DiagonalBlock.SOUTH_EAST);
        this.northWest = (Boolean)ctx.state().getValue((Property)DiagonalBlock.NORTH_WEST);
        this.southWest = (Boolean)ctx.state().getValue((Property)DiagonalBlock.SOUTH_WEST);
        this.noPillar = this.northEast && this.southWest && !this.southEast && !this.northWest || this.southEast && this.northWest && !this.northEast && !this.southWest;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        super.transformQuad(quadMap, quad);
        Direction face = quad.getDirection();
        if (Utils.isY(face)) {
            if (this.northEast) {
                FramedDiagonalPaneGeometry.createDiagonalTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, this.noPillar);
            }
            if (this.southEast) {
                FramedDiagonalPaneGeometry.createDiagonalTopBottomEdgeQuad(quadMap, quad, Direction.EAST, this.noPillar);
            }
            if (this.southWest) {
                FramedDiagonalPaneGeometry.createDiagonalTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, this.noPillar);
            }
            if (this.northWest) {
                FramedDiagonalPaneGeometry.createDiagonalTopBottomEdgeQuad(quadMap, quad, Direction.WEST, this.noPillar);
            }
        } else {
            if (this.isDiagonalSideNotInset(face)) {
                FramedDiagonalPaneGeometry.createDiagonalSideEdgeQuad(quadMap, quad);
            }
            if (Utils.isX(face)) {
                if (this.northEast) {
                    FramedDiagonalPaneGeometry.createDiagonalSideQuad(quadMap.get(null), quad, Direction.NORTH, this.noPillar);
                }
                if (this.southWest) {
                    FramedDiagonalPaneGeometry.createDiagonalSideQuad(quadMap.get(null), quad, Direction.SOUTH, this.noPillar);
                }
            }
            if (Utils.isZ(face)) {
                if (this.southEast) {
                    FramedDiagonalPaneGeometry.createDiagonalSideQuad(quadMap.get(null), quad, Direction.EAST, this.noPillar);
                }
                if (this.northWest) {
                    FramedDiagonalPaneGeometry.createDiagonalSideQuad(quadMap.get(null), quad, Direction.WEST, this.noPillar);
                }
            }
        }
    }

    @Override
    protected boolean isPillarVisible() {
        return !this.noPillar;
    }

    protected static void createDiagonalTopBottomEdgeQuad(QuadMap quadMap, BakedQuad quad, Direction dir, boolean noPillar) {
        Preconditions.checkArgument((!Utils.isY(dir) ? 1 : 0) != 0, (Object)String.format("Invalid direction: %s!", dir));
        QuadModifier.of(quad).apply(Modifiers.cutTopBottom(dir.getOpposite(), noPillar ? 0.5f : 0.4375f)).apply(Modifiers.cutTopBottom(dir.getClockWise().getAxis(), 0.5625f)).apply(FramedDiagonalPaneGeometry.rotate(dir)).export(quadMap.get(null));
    }

    protected static void createDiagonalSideEdgeQuad(QuadMap quadMap, BakedQuad quad) {
        QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(0.5625f)).apply(FramedDiagonalPaneGeometry.rotate(quad.getDirection())).export(quadMap.get(null));
    }

    private static void createDiagonalSideQuad(List<BakedQuad> quadList, BakedQuad quad, Direction dir, boolean noPillar) {
        QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(dir.getOpposite(), noPillar ? 0.5f : 0.4375f)).apply(Modifiers.setPosition(0.5625f)).apply(FramedDiagonalPaneGeometry.rotate(dir)).export(quadList);
    }

    protected boolean isDiagonalSideNotInset(Direction face) {
        return switch (face) {
            case Direction.NORTH -> this.northEast;
            case Direction.EAST -> this.southEast;
            case Direction.SOUTH -> this.southWest;
            case Direction.WEST -> this.northWest;
            default -> throw new IllegalArgumentException(String.format("Invalid face: %s!", face));
        };
    }

    private static QuadModifier.Modifier rotate(Direction dir) {
        return Modifiers.rotateCentered(Direction.Axis.Y, -45.0f, true, new Vector3f((float)dir.getStepX(), 1.0f, (float)dir.getStepZ()));
    }
}

