/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanel.ExtendedSlopePanelShapes;
import xfacthd.framedblocks.common.data.shapes.slopeslab.ElevatedSlopeSlabShapes;

public final class ExtendedCornerSlopePanelWallShapes
implements SplitShapeGenerator {
    public static final ShapeCache<HorizontalRotation> SHAPES = ExtendedCornerSlopePanelWallShapes.makeCache(ElevatedSlopeSlabShapes.SHAPES, ExtendedSlopePanelShapes.SHAPES, false);
    public static final ShapeCache<HorizontalRotation> OCCLUSION_SHAPES = ExtendedCornerSlopePanelWallShapes.makeCache(ElevatedSlopeSlabShapes.OCCLUSION_SHAPES, ExtendedSlopePanelShapes.OCCLUSION_SHAPES, false);
    public static final ShapeCache<HorizontalRotation> INNER_SHAPES = ExtendedCornerSlopePanelWallShapes.makeCache(ElevatedSlopeSlabShapes.SHAPES, ExtendedSlopePanelShapes.SHAPES, true);
    public static final ShapeCache<HorizontalRotation> INNER_OCCLUSION_SHAPES = ExtendedCornerSlopePanelWallShapes.makeCache(ElevatedSlopeSlabShapes.OCCLUSION_SHAPES, ExtendedSlopePanelShapes.OCCLUSION_SHAPES, true);
    private static final ShapeCache<ShapeKey> FINAL_SHAPES = ExtendedCornerSlopePanelWallShapes.makeFinalCache(SHAPES);
    private static final ShapeCache<ShapeKey> FINAL_OCCLUSION_SHAPES = ExtendedCornerSlopePanelWallShapes.makeFinalCache(OCCLUSION_SHAPES);
    private static final ShapeCache<ShapeKey> FINAL_INNER_SHAPES = ExtendedCornerSlopePanelWallShapes.makeFinalCache(INNER_SHAPES);
    private static final ShapeCache<ShapeKey> FINAL_INNER_OCCLUSION_SHAPES = ExtendedCornerSlopePanelWallShapes.makeFinalCache(INNER_OCCLUSION_SHAPES);
    public static final ExtendedCornerSlopePanelWallShapes OUTER = new ExtendedCornerSlopePanelWallShapes(FINAL_SHAPES, FINAL_OCCLUSION_SHAPES);
    public static final ExtendedCornerSlopePanelWallShapes INNER = new ExtendedCornerSlopePanelWallShapes(FINAL_INNER_SHAPES, FINAL_INNER_OCCLUSION_SHAPES);
    private final ShapeCache<ShapeKey> shapes;
    private final ShapeCache<ShapeKey> occlusionShapes;

    private ExtendedCornerSlopePanelWallShapes(ShapeCache<ShapeKey> shapes, ShapeCache<ShapeKey> occlusionShapes) {
        this.shapes = shapes;
        this.occlusionShapes = occlusionShapes;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return ExtendedCornerSlopePanelWallShapes.generate(states, this.shapes);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return ExtendedCornerSlopePanelWallShapes.generate(states, this.occlusionShapes);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<ShapeKey> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            builder.put((Object)state, (Object)cache.get(new ShapeKey(dir, rot)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<HorizontalRotation> makeCache(ShapeCache<Boolean> slabCache, ShapeCache<HorizontalRotation> panelCache, boolean inner) {
        return ShapeCache.createEnum(HorizontalRotation.class, map -> {
            VoxelShape leftPanel = panelCache.get(HorizontalRotation.LEFT);
            VoxelShape rightPanel = panelCache.get(HorizontalRotation.RIGHT);
            VoxelShape shapeOneUpLeft = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, inner ? Direction.EAST : Direction.WEST, inner ? rightPanel : leftPanel);
            VoxelShape shapeOneDownRight = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, inner ? Direction.WEST : Direction.EAST, inner ? leftPanel : rightPanel);
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                VoxelShape shapeOne = switch (rot) {
                    default -> throw new MatchException(null, null);
                    case HorizontalRotation.UP, HorizontalRotation.LEFT -> shapeOneUpLeft;
                    case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> shapeOneDownRight;
                };
                VoxelShape shapeTwo = switch (rot) {
                    default -> throw new MatchException(null, null);
                    case HorizontalRotation.UP, HorizontalRotation.RIGHT -> slabCache.get(!inner);
                    case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> slabCache.get(inner);
                };
                map.put(rot, Shapes.joinUnoptimized((VoxelShape)shapeOne, (VoxelShape)shapeTwo, (BooleanOp)(inner ? BooleanOp.OR : BooleanOp.AND)));
            }
        });
    }

    private static ShapeCache<ShapeKey> makeFinalCache(ShapeCache<HorizontalRotation> cache) {
        return ShapeCache.create(map -> {
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                ShapeUtils.makeHorizontalRotations(cache.get(rot), Direction.NORTH, map, rot, ShapeKey::new);
            }
        });
    }

    private record ShapeKey(Direction dir, HorizontalRotation rot) {
    }
}

