/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.stairs.standard;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slope.VerticalHalfSlopeShapes;

public final class SlopedStairsShapes
implements SplitShapeGenerator {
    public static final SlopedStairsShapes INSTANCE = new SlopedStairsShapes();
    private static final ShapeCache<CommonShapes.DirBoolKey> SHAPES = SlopedStairsShapes.makeCache(VerticalHalfSlopeShapes.SHAPES);
    private static final ShapeCache<CommonShapes.DirBoolKey> OCCLUSION_SHAPES = SlopedStairsShapes.makeCache(VerticalHalfSlopeShapes.OCCLUSION_SHAPES);

    private SlopedStairsShapes() {
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return SlopedStairsShapes.generateShapes(states, SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return SlopedStairsShapes.generateShapes(states, OCCLUSION_SHAPES);
    }

    private static ShapeProvider generateShapes(ImmutableList<BlockState> states, ShapeCache<CommonShapes.DirBoolKey> shapeCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapeCache.get(new CommonShapes.DirBoolKey(dir, top)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<CommonShapes.DirBoolKey> makeCache(ShapeCache<Boolean> shapeCache) {
        return ShapeCache.create(map -> {
            VoxelShape shapeBottom = ShapeUtils.orUnoptimized(shapeCache.get(Boolean.TRUE), CommonShapes.SLAB.get(Boolean.FALSE));
            VoxelShape shapeTop = ShapeUtils.orUnoptimized(shapeCache.get(Boolean.FALSE), CommonShapes.SLAB.get(Boolean.TRUE));
            ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.NORTH, map, CommonShapes.DirBoolKey::new);
        });
    }
}

