/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;

@CullTest(value={BlockType.FRAMED_FENCE_GATE})
public final class FenceGateSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object;
        boolean perp;
        Direction dir = (Direction)state.getValue((Property)FenceGateBlock.FACING);
        boolean bl = perp = dir.getClockWise().getAxis() == side.getAxis();
        if (perp && (object = adjState.getBlock()) instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean inWall = (Boolean)state.getValue((Property)FenceGateBlock.IN_WALL);
            return switch (type) {
                case BlockType.FRAMED_FENCE_GATE -> FenceGateSkipPredicate.testAgainstFenceGate(dir, inWall, adjState);
                case BlockType.FRAMED_WALL -> FenceGateSkipPredicate.testAgainstWall(inWall, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FENCE_GATE})
    private static boolean testAgainstFenceGate(Direction dir, boolean inWall, BlockState adjState) {
        Direction adjDir = (Direction)adjState.getValue((Property)FenceGateBlock.FACING);
        return adjDir.getAxis() == dir.getAxis() && inWall == (Boolean)adjState.getValue((Property)FenceGateBlock.IN_WALL);
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_WALL}, oneWay=true)
    private static boolean testAgainstWall(boolean inWall, BlockState adjState, Direction side) {
        return inWall && PillarDirs.Wall.getWallSide(adjState, side.getOpposite()) != WallSide.NONE;
    }
}

