/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SlopePanelCornerDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabDirs;

@CullTest(value={BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER})
public final class FlatElevatedInnerSlopeSlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            return switch (blockType) {
                case BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedInnerSlopeSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedSlopeSlab(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedInnerSlopeSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatElevatedInnerSlopeSlabCorner.getTriDir(dir, top, side).isEqualTo(SlopeSlabDirs.FlatElevatedInnerSlopeSlabCorner.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatElevatedInnerSlopeSlabCorner.getTriDir(dir, top, side).isEqualTo(SlopeSlabDirs.ElevatedSlopeSlab.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatElevatedInnerSlopeSlabCorner.getTriDir(dir, top, side).isEqualTo(SlopeSlabDirs.FlatElevatedSlopeSlabCorner.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeSlabDirs.FlatElevatedInnerSlopeSlabCorner.getTriDir(dir, top, side).isEqualTo(SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeSlabDirs.FlatElevatedInnerSlopeSlabCorner.getTriDir(dir, top, side).isEqualTo(SlopePanelCornerDirs.ExtendedInnerCornerSlopePanelWall.getTriDir(adjDir, adjRot, side.getOpposite()));
    }
}

