/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import net.neoforged.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.common.data.BlockType;

public abstract class BlockTypeMap<T> {
    private static final BlockType[] TYPES = BlockType.values();
    private static final int TYPE_COUNT = TYPES.length;
    private final T defaultValue;
    private final Object[] values = new Object[TYPE_COUNT];

    protected BlockTypeMap(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public final void initialize() {
        this.fill();
        if (!FMLEnvironment.production) {
            this.check();
        }
    }

    protected abstract void fill();

    private void check() {
        int missing = 0;
        for (int i = 0; i < TYPE_COUNT; ++i) {
            if (this.values[i] != null) continue;
            ++missing;
            FramedBlocks.LOGGER.error("Type '{}' missing mapping in '{}'", (Object)TYPES[i], (Object)this.getClass().getSimpleName());
        }
        if (missing > 0) {
            FramedBlocks.LOGGER.error("Found {} missing mappings in '{}'", (Object)missing, (Object)this.getClass().getSimpleName());
        }
    }

    protected final void put(BlockType type, T value) {
        this.values[type.ordinal()] = Objects.requireNonNull(value);
    }

    public final T get(BlockType type) {
        Object value = this.values[Objects.requireNonNull(type).ordinal()];
        if (value != null) {
            return (T)value;
        }
        return this.defaultValue;
    }

    public final void forEach(BiConsumer<BlockType, T> consumer) {
        for (BlockType type : TYPES) {
            consumer.accept(type, (BlockType)this.get(type));
        }
    }
}

