/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.item.ItemUtils;
import de.maxhenkel.corpse.entities.CorpseBoundingBoxBase;
import de.maxhenkel.corpse.gui.Guis;
import de.maxhenkel.corpse.net.MessageSpawnDeathParticles;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public class CorpseEntity
extends CorpseBoundingBoxBase {
    private static final EntityDataAccessor<Optional<UUID>> ID = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> SKELETON = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> MODEL = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<NonNullList<ItemStack>> EQUIPMENT = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)((EntityDataSerializer)Main.ITEM_LIST_SERIALIZER.get()));
    private int age;
    private int emptyAge;
    protected Death death;

    public CorpseEntity(EntityType type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
        this.emptyAge = -1;
        this.death = new Death.Builder(new UUID(0L, 0L), new UUID(0L, 0L)).build();
    }

    public CorpseEntity(Level world) {
        this((EntityType)Main.CORPSE_ENTITY_TYPE.get(), world);
    }

    public static CorpseEntity createFromDeath(Player player, Death death) {
        CorpseEntity corpse = new CorpseEntity(player.level());
        corpse.death = death;
        corpse.setCorpseUUID(death.getPlayerUUID());
        corpse.setCorpseName(death.getPlayerName());
        corpse.setEquipment(death.getEquipment());
        corpse.setPos(death.getPosX(), Math.max(death.getPosY(), (double)player.level().getMinBuildHeight()), death.getPosZ());
        corpse.setYRot(player.getYRot());
        corpse.setCorpseModel(death.getModel());
        return corpse;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            double yMotion = 0.0;
            Vec3 motion = this.getDeltaMovement();
            if (this.isEyeInFluid(FluidTags.WATER) || this.isEyeInFluid(FluidTags.LAVA)) {
                yMotion = motion.y < 0.0 ? motion.y + (motion.y < 0.03 ? 0.01 : 0.0) : motion.y + (motion.y < 0.03 ? 5.0E-4 : 0.0);
            } else if (((Boolean)Main.SERVER_CONFIG.fallIntoVoid.get()).booleanValue() || this.getY() > (double)this.level().getMinBuildHeight()) {
                yMotion = Math.max(-2.0, motion.y - 0.0625);
            }
            this.setDeltaMovement(this.getDeltaMovement().x * 0.75, yMotion, this.getDeltaMovement().z * 0.75);
            if (!((Boolean)Main.SERVER_CONFIG.fallIntoVoid.get()).booleanValue() && this.getY() < (double)this.level().getMinBuildHeight()) {
                this.teleportTo(this.getX(), this.level().getMinBuildHeight(), this.getZ());
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        if (this.level().isClientSide) {
            return;
        }
        ++this.age;
        this.setIsSkeleton(this.age >= (Integer)Main.SERVER_CONFIG.corpseSkeletonTime.get());
        if ((Integer)Main.SERVER_CONFIG.corpseForceDespawnTime.get() > 0 && this.age > (Integer)Main.SERVER_CONFIG.corpseForceDespawnTime.get()) {
            this.discard();
            return;
        }
        boolean empty = this.isEmpty();
        if (empty && this.emptyAge < 0) {
            this.emptyAge = this.age;
        } else if (empty && this.age - this.emptyAge >= (Integer)Main.SERVER_CONFIG.corpseDespawnTime.get()) {
            this.discard();
        }
    }

    public boolean isMainInventoryEmpty() {
        return this.death.getMainInventory().stream().allMatch(ItemStack::isEmpty) && this.death.getArmorInventory().stream().allMatch(ItemStack::isEmpty) && this.death.getOffHandInventory().stream().allMatch(ItemStack::isEmpty);
    }

    public boolean isAdditionalInventoryEmpty() {
        return this.death.getAdditionalItems().stream().allMatch(ItemStack::isEmpty);
    }

    public boolean isEmpty() {
        return this.isMainInventoryEmpty() && this.isAdditionalInventoryEmpty();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (((Boolean)Main.SERVER_CONFIG.lavaDamage.get()).booleanValue() && source.is(DamageTypeTags.IS_FIRE) && amount >= 2.0f) {
            this.discard();
        }
        return super.hurt(source, amount);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)player;
            if (((Boolean)Main.SERVER_CONFIG.onlyOwnerAccess.get()).booleanValue()) {
                boolean isOp = playerMP.hasPermissions(playerMP.server.getOperatorUserPermissionLevel());
                if (isOp || !this.getCorpseUUID().isPresent() || playerMP.getUUID().equals(this.getCorpseUUID().get())) {
                    Guis.openCorpseGUI((ServerPlayer)player, this);
                } else if (((Boolean)Main.SERVER_CONFIG.skeletonAccess.get()).booleanValue() && this.isSkeleton()) {
                    Guis.openCorpseGUI((ServerPlayer)player, this);
                }
            } else {
                Guis.openCorpseGUI((ServerPlayer)player, this);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Component getDisplayName() {
        String name = this.getCorpseName();
        if (name == null || name.trim().isEmpty()) {
            return super.getDisplayName();
        }
        return Component.translatable((String)"entity.corpse.corpse_of", (Object[])new Object[]{this.getCorpseName()});
    }

    public boolean displayFireAnimation() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox();
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public Optional<UUID> getCorpseUUID() {
        return (Optional)this.entityData.get(ID);
    }

    public void setCorpseUUID(UUID uuid) {
        if (uuid == null) {
            this.entityData.set(ID, Optional.empty());
        } else {
            this.entityData.set(ID, Optional.of(uuid));
        }
    }

    public Death getDeath() {
        return this.death;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDeath(Death death) {
        this.death = death;
    }

    public String getCorpseName() {
        return (String)this.entityData.get(NAME);
    }

    public void setCorpseName(String name) {
        this.entityData.set(NAME, (Object)name);
    }

    public boolean isSkeleton() {
        return (Boolean)this.entityData.get(SKELETON);
    }

    public void setIsSkeleton(boolean skeleton) {
        this.entityData.set(SKELETON, (Object)skeleton);
    }

    public byte getCorpseModel() {
        return (Byte)this.entityData.get(MODEL);
    }

    public void setCorpseModel(byte model) {
        this.entityData.set(MODEL, (Object)model);
    }

    public void setEquipment(NonNullList<ItemStack> equipment) {
        this.entityData.set(EQUIPMENT, equipment);
    }

    public NonNullList<ItemStack> getEquipment() {
        return (NonNullList)this.entityData.get(EQUIPMENT);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ID, Optional.empty());
        builder.define(NAME, (Object)"");
        builder.define(SKELETON, (Object)false);
        builder.define(MODEL, (Object)0);
        builder.define(EQUIPMENT, (Object)NonNullList.withSize((int)EquipmentSlot.values().length, (Object)ItemStack.EMPTY));
    }

    public void remove(Entity.RemovalReason reason) {
        for (ItemStack item : this.death.getAllItems()) {
            Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)item);
        }
        super.remove(reason);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getPlayers(player -> player.distanceToSqr(this.getX(), this.getY(), this.getZ()) <= 4096.0).forEach(playerEntity -> PacketDistributor.sendToPlayer((ServerPlayer)playerEntity, (CustomPacketPayload)new MessageSpawnDeathParticles(this.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    public void spawnDeathParticles() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Vec3 lookVec = this.getLookAngle().normalize();
        for (int i = 0; i <= 10; ++i) {
            double d = ((double)i / 10.0 - 0.5) * 2.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x + lookVec.x * d + (this.level().random.nextDouble() - 0.5), y + 0.25, z + lookVec.z * d + (this.level().random.nextDouble() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Death")) {
            this.death = Death.fromNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound("Death"));
        } else {
            UUID playerUUID = new UUID(compound.getLong("IDMost"), compound.getLong("IDLeast"));
            UUID deathID = new UUID(compound.getLong("DeathIDMost"), compound.getLong("DeathIDLeast"));
            Death.Builder builder = new Death.Builder(playerUUID, deathID);
            int size = compound.getInt("InventorySize");
            NonNullList additionalItems = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            ItemUtils.readInventory((HolderLookup.Provider)this.registryAccess(), compound, "Inventory", (NonNullList<ItemStack>)additionalItems);
            builder.additionalItems((NonNullList<ItemStack>)additionalItems);
            NonNullList equipment = NonNullList.withSize((int)EquipmentSlot.values().length, (Object)ItemStack.EMPTY);
            ItemUtils.readItemList((HolderLookup.Provider)this.registryAccess(), compound, "Equipment", (NonNullList<ItemStack>)equipment);
            builder.equipment((NonNullList<ItemStack>)equipment);
            builder.playerName(compound.getString("Name"));
            this.death = builder.build();
        }
        this.setEquipment(this.death.getEquipment());
        this.setCorpseUUID(this.death.getPlayerUUID());
        this.setCorpseName(this.death.getPlayerName());
        this.setCorpseModel(this.death.getModel());
        this.age = compound.getInt("Age");
        if (compound.contains("EmptyAge")) {
            this.emptyAge = compound.getInt("EmptyAge");
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.put("Death", (Tag)this.death.toNBT((HolderLookup.Provider)this.registryAccess()));
        compound.putInt("Age", this.age);
        if (this.emptyAge >= 0) {
            compound.putInt("EmptyAge", this.emptyAge);
        }
    }
}

