/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.integration.waila;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.DeathHistoryScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerCorpse
implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor> {
    public static final ResourceLocation OBJECT_NAME_TAG = ResourceLocation.fromNamespaceAndPath((String)"jade", (String)"object_name");
    public static final HUDHandlerCorpse INSTANCE = new HUDHandlerCorpse();
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"corpse", (String)"corpse");

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof CorpseEntity) {
            Death death;
            long timestamp;
            CorpseEntity corpse = (CorpseEntity)entity;
            iTooltip.remove(OBJECT_NAME_TAG);
            iTooltip.add((Component)corpse.getDisplayName().copy().withStyle(ChatFormatting.WHITE));
            CompoundTag data = entityAccessor.getServerData();
            if (data.contains("Death") && (timestamp = (death = Death.fromNBT((HolderLookup.Provider)corpse.registryAccess(), data.getCompound("Death"))).getTimestamp()) > 0L) {
                iTooltip.add((Component)Component.translatable((String)"tooltip.corpse.death_date", (Object[])new Object[]{DeathHistoryScreen.getDate(timestamp)}));
            }
            if (data.contains("ItemCount")) {
                iTooltip.add((Component)Component.translatable((String)"tooltip.corpse.item_count", (Object[])new Object[]{data.getInt("ItemCount")}));
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, EntityAccessor entityAccessor) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof CorpseEntity) {
            CorpseEntity corpse = (CorpseEntity)entity;
            Death death = corpse.getDeath();
            compoundTag.put("Death", (Tag)death.toNBT((HolderLookup.Provider)corpse.registryAccess(), false));
            compoundTag.putInt("ItemCount", (int)death.getAllItems().stream().filter(itemStack -> !itemStack.isEmpty()).count());
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

