/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils.files;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class CodecSavedData<T>
extends SavedData
implements Supplier<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Factory<T> factory;
    private T data;

    private CodecSavedData(Factory<T> factory, CompoundTag tag, HolderLookup.Provider provider) {
        this.factory = factory;
        this.data = factory.codec.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).ifError(e -> LOGGER.error("Failed to parse data for {}", (Object)factory.path, e)).result().orElseGet(factory.defaultValue);
    }

    private CodecSavedData(Factory<T> factory) {
        this.factory = factory;
        this.data = factory.defaultValue.get();
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        this.factory.codec.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.get()).ifError(e -> LOGGER.error("Failed to encode data for {}", (Object)this.factory.path, e)).result().ifPresent(compound -> {
            if (compound instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)compound;
                if (this.factory.clean) {
                    HashSet keys = new HashSet(tag.getAllKeys());
                    keys.forEach(arg_0 -> ((CompoundTag)tag).remove(arg_0));
                }
                tag.merge(compoundTag);
            } else {
                LOGGER.error("Codec {} did not return a CompoundTag for {}", this.factory.codec, (Object)this.factory.path);
            }
        });
        return tag;
    }

    public boolean isDirty() {
        return this.factory.alwaysDirty || super.isDirty();
    }

    @Override
    public T get() {
        return this.data;
    }

    public void set(T data) {
        this.data = data;
        this.setDirty();
    }

    public static <T> Factory<T> create(Codec<T> codec, String path) {
        return new Factory<T>(codec, path);
    }

    public static class Factory<T> {
        private final Codec<T> codec;
        private final String path;
        private Supplier<T> defaultValue = () -> null;
        private boolean alwaysDirty = false;
        private boolean global = false;
        private boolean clean = false;
        private SavedData.Factory<CodecSavedData<T>> factory;

        private Factory(Codec<T> codec, String path) {
            this.codec = codec;
            this.path = path;
        }

        public Factory<T> defaultValue(Supplier<T> defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Factory<T> alwaysDirty() {
            this.alwaysDirty = true;
            return this;
        }

        public Factory<T> global() {
            this.global = true;
            return this;
        }

        public Factory<T> clean() {
            this.clean = true;
            return this;
        }

        public CodecSavedData<T> create(ServerLevel level) {
            DimensionDataStorage storage;
            DimensionDataStorage dimensionDataStorage = storage = this.global ? level.getServer().overworld().getDataStorage() : level.getDataStorage();
            if (this.factory == null) {
                this.factory = new SavedData.Factory(() -> new CodecSavedData(this), (tag, provider) -> new CodecSavedData(this, (CompoundTag)tag, (HolderLookup.Provider)provider), null);
            }
            return (CodecSavedData)storage.computeIfAbsent(this.factory, this.path);
        }
    }
}

