/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles;

import com.girafi.waddles.CommonClass;
import com.girafi.waddles.PenguinSpawn;
import com.girafi.waddles.entity.AdeliePenguinEntity;
import com.girafi.waddles.init.PenguinRegistry;
import com.girafi.waddles.utils.ConfigurationHandler;
import java.util.function.Supplier;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="waddles")
public class Waddles {
    public static final DeferredRegister.Items ITEM_DEFERRED = DeferredRegister.createItems((String)"waddles");

    public Waddles(ModContainer modContainer, IEventBus eventBus) {
        CommonClass.init();
        eventBus.addListener(this::setupCommon);
        eventBus.addListener(this::setupClient);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigurationHandler.spec);
        Waddles.registerDeferredRegistries(eventBus);
        this.register();
    }

    public void setupCommon(FMLCommonSetupEvent event) {
    }

    public void setupClient(FMLClientSetupEvent event) {
    }

    public void register() {
        PenguinRegistry.PENGUINS.forEach((penguin, name) -> {
            DeferredItem spawnEgg = ITEM_DEFERRED.register(name + "_spawn_egg", () -> new DeferredSpawnEggItem((Supplier)penguin, PenguinRegistry.PENGUIN_EGG_PRIMARY.get(penguin).intValue(), PenguinRegistry.PENGUIN_EGG_SECONDARY.get(penguin).intValue(), new Item.Properties()));
            PenguinRegistry.SPAWN_EGGS.add((Supplier<Item>)spawnEgg);
        });
        PenguinSpawn.BIOME_MODIFIER_SERIALIZERS_DEFERRED.register("penguin_spawn", PenguinSpawn.PenguinBiomeModifier::makeCodec);
    }

    public static void registerDeferredRegistries(IEventBus modBus) {
        PenguinSpawn.BIOME_MODIFIER_SERIALIZERS_DEFERRED.register(modBus);
        ITEM_DEFERRED.register(modBus);
    }

    @EventBusSubscriber(modid="waddles", bus=EventBusSubscriber.Bus.MOD)
    public static class Events {
        @SubscribeEvent
        public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register(PenguinRegistry.ADELIE_PENGUIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AdeliePenguinEntity::canPenguinSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        }

        @SubscribeEvent
        public static void addEntityAttributes(EntityAttributeCreationEvent event) {
            event.put(PenguinRegistry.ADELIE_PENGUIN.get(), AdeliePenguinEntity.createAttributes().build());
        }

        @SubscribeEvent
        public static void addToCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
                PenguinRegistry.SPAWN_EGGS.forEach(stack -> event.accept((ItemLike)stack.get()));
            }
        }
    }
}

