/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client.itemstack;

import com.minecraftserverzone.weaponmaster.setup.networking.client.itemstack.ItemStackCPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    public static void handleData(ItemStackCPacket data, IPayloadContext context) {
        ClientPayloadHandler.playerChanged(data);
        context.enqueueWork(() -> ClientPayloadHandler.playerChanged(data)).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playerChanged(ItemStackCPacket packetdata) {
        assert (Minecraft.getInstance().level != null);
        for (Player target : Minecraft.getInstance().level.players()) {
            if (!target.getStringUUID().equals(packetdata.uuid())) continue;
            PlayerData data = ((IPlayerData)target).getPlayerData();
            ItemStack value = new ItemStack((ItemLike)Item.byId((int)packetdata.itemID()));
            if (data == null || value == null) continue;
            data.inventory[packetdata.slot()] = value;
        }
    }
}

