/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.server.whitelist;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.whitelist.WhitelistCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.whitelist.WhitelistSPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleData(WhitelistSPacket data, IPayloadContext context) {
        ServerPayloadHandler.playerChanged(data, context.player());
        context.enqueueWork(() -> ServerPayloadHandler.playerChanged(data, context.player())).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed.server", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(WhitelistSPacket packetdata, Player sender) {
        PlayerData data;
        assert (sender.level() != null);
        if (!sender.level().isClientSide() && (data = ((IPlayerData)sender).getPlayerData()) != null) {
            data.whitelist = ModUtils.stringExist(packetdata.value()) ? packetdata.value() : "empty";
            if (!((Boolean)ConfigHolder.COMMON.CAN_CHANGE_WHITELIST.get()).booleanValue() && ModUtils.stringExist((String)ConfigHolder.COMMON.whitelist.get())) {
                data.whitelist = (String)ConfigHolder.COMMON.whitelist.get();
            }
            for (Player sp : sender.level().players()) {
                Networking.sendToClient(new WhitelistCPacket(data.whitelist, false, sender.getStringUUID()), (ServerPlayer)sp);
            }
        }
    }
}

