/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.stackable_stew_and_soup;

import com.cursee.monolib.util.toml.Toml;
import com.cursee.monolib.util.toml.TomlWriter;
import forge.com.cursee.stackable_stew_and_soup.Constants;
import forge.com.cursee.stackable_stew_and_soup.platform.Services;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigForge
implements IMixinConfigPlugin {
    public static long STACKABLE_AMOUNT;
    public static final Map<String, Object> defaults;

    public void onLoad(String mixinPackage) {
        defaults.put("stackable_amount", STACKABLE_AMOUNT);
        File CONFIG_DIRECTORY = new File(com.cursee.monolib.platform.Services.PLATFORM.getGameDirectory() + File.separator + "config");
        if (!CONFIG_DIRECTORY.isDirectory()) {
            CONFIG_DIRECTORY.mkdir();
        }
        String CONFIG_FILEPATH = CONFIG_DIRECTORY + File.separator + "stackable_stew_and_soup.toml";
        File CONFIG_FILE = new File(CONFIG_FILEPATH);
        MixinConfigForge.handle(CONFIG_FILE);
    }

    private static void handle(File file) {
        if (!file.isFile()) {
            MixinConfigForge.createConfigurationFile(file);
        } else {
            MixinConfigForge.loadConfigurationFile(file);
        }
    }

    private static void createConfigurationFile(File file) {
        try {
            TomlWriter writer = new TomlWriter();
            writer.write(defaults, file);
        }
        catch (IOException exception) {
            Constants.LOG.error("Fatal error occurred while attempting to write stackable_stew_and_soup.toml");
            Constants.LOG.error("Did another process delete the config directory during writing?");
            Constants.LOG.error(exception.getMessage());
        }
    }

    private static void loadConfigurationFile(File file) {
        try {
            Toml toml = new Toml().read(file);
            STACKABLE_AMOUNT = toml.getLong("stackable_amount");
        }
        catch (IllegalStateException exception) {
            Constants.LOG.error("Fatal error occurred while attempting to read stackable_stew_and_soup.toml");
            Constants.LOG.error("Did another process delete the file during reading?");
            Constants.LOG.error(exception.getMessage());
        }
    }

    public String getRefMapperConfig() {
        return "";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            Constants.LOG.info("MixinConfigForge static initialization occurring!");
            Constants.LOG.info(" -  with getCanonicalName() {}", (Object)MixinConfigForge.class.getCanonicalName());
            Constants.LOG.info(" -  with descriptorString() {}", (Object)MixinConfigForge.class.descriptorString());
            Constants.LOG.info(" -  with getName() {}", (Object)MixinConfigForge.class.getName());
            Constants.LOG.info(" -  with getPackageName() {}", (Object)MixinConfigForge.class.getPackageName());
            Constants.LOG.info(" -  with getTypeName() {}", (Object)MixinConfigForge.class.getTypeName());
            Constants.LOG.info(" -  with getSimpleName() {}", (Object)MixinConfigForge.class.getSimpleName());
        }
        STACKABLE_AMOUNT = 8L;
        defaults = new HashMap<String, Object>();
    }
}

