/*
 * Decompiled with CFR 0.152.
 */
package slexom.animal_feeding_trough.platform.common.goal.entity.ai;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import slexom.animal_feeding_trough.platform.common.block.entity.FeedingTroughBlockEntity;

public class SelfFeedGoal
extends MoveToBlockGoal {
    protected final Animal mob;
    private final Predicate<ItemStack> foodPredicate;
    private FeedingTroughBlockEntity feeder;

    public SelfFeedGoal(Animal mob, double speed, Predicate<ItemStack> foodPredicate) {
        super((PathfinderMob)mob, speed, 8);
        this.mob = mob;
        this.foodPredicate = foodPredicate;
    }

    public boolean canUse() {
        return this.mob.canFallInLove() && this.mob.getAge() == 0 && super.canUse();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.feeder != null && this.mob.canFallInLove() && this.mob.getAge() == 0;
    }

    public double acceptedDistance() {
        return 2.0;
    }

    private boolean hasCorrectFood(ItemStack itemStack) {
        return this.foodPredicate.test(itemStack);
    }

    protected boolean isValidTarget(LevelReader world, BlockPos pos) {
        FeedingTroughBlockEntity feedingTroughBlockEntity;
        ItemStack itemStack;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FeedingTroughBlockEntity && !(itemStack = (ItemStack)(feedingTroughBlockEntity = (FeedingTroughBlockEntity)blockEntity).getItems().get(0)).isEmpty() && this.hasCorrectFood(itemStack)) {
            this.feeder = feedingTroughBlockEntity;
            return true;
        }
        return false;
    }

    public void tick() {
        Level world = this.mob.level();
        if (!world.isClientSide && this.feeder != null && this.mob.canFallInLove()) {
            if (!((ItemStack)this.feeder.getItems().get(0)).isEmpty()) {
                this.mob.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5, 10.0f, (float)this.mob.getMaxHeadXRot());
                if (this.isReachedTarget()) {
                    ((ItemStack)this.feeder.getItems().get(0)).shrink(1);
                    this.mob.setInLove(null);
                }
            }
            this.feeder = null;
        }
        super.tick();
    }
}

