/*
 * Decompiled with CFR 0.152.
 */
package slexom.animal_feeding_trough.platform.common.screen;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import slexom.animal_feeding_trough.platform.common.AnimalFeedingTroughMod;

public class FeedingTroughScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;

    public FeedingTroughScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(1));
    }

    public FeedingTroughScreenHandler(int syncId, Inventory playerInventory, Container inventory) {
        super((MenuType)AnimalFeedingTroughMod.FEEDING_TROUGH_SCREEN_HANDLER.get(), syncId);
        FeedingTroughScreenHandler.checkContainerSize((Container)inventory, (int)1);
        this.inventory = inventory;
        inventory.startOpen(playerInventory.player);
        this.addSlot(new Slot(inventory, 0, 80, 26));
        this.drawPlayerInventory(playerInventory);
        this.drawHotbar(playerInventory);
    }

    private void drawPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void drawHotbar(Inventory playerInventory) {
        for (int row = 0; row < 9; ++row) {
            this.addSlot(new Slot((Container)playerInventory, row, 8 + row * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }
}

