/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.more_bows_and_arrows.core.registry;

import fabric.com.cursee.more_bows_and_arrows.Constants;
import fabric.com.cursee.more_bows_and_arrows.core.ModConfig;
import fabric.com.cursee.more_bows_and_arrows.core.util.DeferredRegistryObject;
import fabric.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import fabric.com.cursee.more_bows_and_arrows.core.world.item.ModArrowItem;
import fabric.com.cursee.more_bows_and_arrows.core.world.item.ModBowItem;
import fabric.com.cursee.more_bows_and_arrows.core.world.item.util.BowType;
import fabric.com.cursee.more_bows_and_arrows.platform.Services;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import net.minecraft.class_1792;
import net.minecraft.class_7923;

public class ModItems {
    public static final LinkedHashMap<ArrowType, DeferredRegistryObject<class_1792>> ARROW_ITEM_FROM_TYPE_MAP = new LinkedHashMap();
    public static final LinkedHashMap<BowType, DeferredRegistryObject<class_1792>> BOW_ITEM_FROM_TYPE_MAP = new LinkedHashMap();
    public static final LinkedList<DeferredRegistryObject<class_1792>> ITEMS_FOR_TAB = new LinkedList();

    public static void loadClass() {
        ModItems.initializeItems();
    }

    private static void initializeItems() {
        if (!ModConfig.BANNED_BOWS.isEmpty()) {
            Constants.LOG.info("Some bows were banned: ");
            ModConfig.BANNED_BOWS.forEach(System.out::println);
        }
        for (BowType bowType : BowType.values()) {
            DeferredRegistryObject<class_1792> bow = Services.PLATFORM.register(class_7923.field_41178, bowType.name().toLowerCase() + "_bow", () -> new ModBowItem(bowType, new class_1792.class_1793()));
            if (bowType != BowType.NORMAL) {
                ITEMS_FOR_TAB.add(bow);
            }
            BOW_ITEM_FROM_TYPE_MAP.put(bowType, bow);
        }
        if (ModConfig.BANNED_ARROWS != null && !ModConfig.BANNED_ARROWS.isEmpty()) {
            Constants.LOG.info("Some arrows were banned: ");
            ModConfig.BANNED_ARROWS.forEach(System.out::println);
        }
        for (Enum enum_ : ArrowType.values()) {
            DeferredRegistryObject<class_1792> arrow = Services.PLATFORM.register(class_7923.field_41178, enum_.name().toLowerCase() + "_arrow", () -> ModItems.lambda$initializeItems$1((ArrowType)enum_));
            if (enum_ != ArrowType.NORMAL) {
                ITEMS_FOR_TAB.add(arrow);
            }
            ARROW_ITEM_FROM_TYPE_MAP.put((ArrowType)enum_, arrow);
        }
    }

    private static /* synthetic */ class_1792 lambda$initializeItems$1(ArrowType type) {
        return new ModArrowItem(type, new class_1792.class_1793());
    }
}

