/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util;

import java.util.Random;
import neoforge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.ModArrow;
import neoforge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import neoforge.com.cursee.more_bows_and_arrows.core.world.item.ModBowItem;
import neoforge.com.cursee.more_bows_and_arrows.core.world.item.util.BowType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

@FunctionalInterface
public interface IModArrow {
    public ArrowType getArrowType();

    default public void processBlockInteraction(ModArrow arrow, BlockHitResult result) {
        Entity owner = arrow.getOwner();
        Level level = arrow.level();
        BlockPos pos = result.getBlockPos();
        BlockState state = arrow.level().getBlockState(pos);
        ItemStack stack = owner instanceof LivingEntity ? ((LivingEntity)owner).getMainHandItem() : ItemStack.EMPTY;
        ModBowItem bow = stack.getItem() instanceof ModBowItem ? (ModBowItem)stack.getItem() : null;
        switch (this.getArrowType()) {
            case BAMBOO: {
                if (bow == null || bow.getBowType() != BowType.BAMBOO) break;
                IModArrow.bambooArrowHitsBlock(level, pos, state);
                break;
            }
            case BLAZE_ROD: {
                IModArrow.igniteBlockOnHit(result, level, pos, state);
                break;
            }
            case COPPER: {
                LightningBolt lightningBolt;
                if (level.random.nextFloat() < 0.01f && level.isRainingAt(pos)) {
                    lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                    lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos.above()));
                    lightningBolt.setCause(null);
                    level.addFreshEntity((Entity)lightningBolt);
                }
                if (bow == null || bow.getBowType() != BowType.COPPER) break;
                lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos.above()));
                lightningBolt.setCause(null);
                level.addFreshEntity((Entity)lightningBolt);
                break;
            }
            case ENDER_PEARL: {
                BlockPos relativePosition = pos.relative(result.getDirection());
                if (owner == null || arrow.level().isClientSide()) break;
                owner.teleportTo((ServerLevel)arrow.level(), (double)relativePosition.getX(), (double)relativePosition.getY(), (double)relativePosition.getZ(), RelativeMovement.ROTATION, owner.getYRot(), owner.getXRot());
                break;
            }
            case FLINT_AND_STEEL: {
                IModArrow.igniteBlockOnHit(result, level, pos, state);
                break;
            }
            case FLINT: {
                if (bow == null || bow.getBowType() != BowType.IRON) break;
                IModArrow.igniteBlockOnHit(result, level, pos, state);
                break;
            }
            case MOSS: {
                if (bow == null || bow.getBowType() != BowType.MOSS && bow.getBowType() != BowType.PAPER) break;
                IModArrow.paperArrowHitsBlock(owner, level, pos);
                break;
            }
            case PAPER: {
                if (bow == null || bow.getBowType() != BowType.PAPER && bow.getBowType() != BowType.MOSS) break;
                IModArrow.paperArrowHitsBlock(owner, level, pos);
                break;
            }
            case TNT: {
                arrow.discard();
                level.explode(owner, (double)result.getBlockPos().getX(), (double)(result.getBlockPos().getY() + 1), (double)result.getBlockPos().getZ(), 2.0f, true, Level.ExplosionInteraction.TNT);
            }
        }
    }

    default public void processEntityInteraction(ModArrow arrow, EntityHitResult result) {
        Player player;
        ModBowItem bow;
        Entity owner = arrow.getOwner();
        Level level = arrow.level();
        Entity entity = result.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity hitEntity = (LivingEntity)entity;
        ItemStack stack = owner instanceof LivingEntity ? ((LivingEntity)owner).getMainHandItem() : ItemStack.EMPTY;
        ModBowItem modBowItem = bow = stack.getItem() instanceof ModBowItem ? (ModBowItem)stack.getItem() : null;
        if (owner instanceof Player && (player = (Player)owner).level() != null) {
            hitEntity.invulnerableTime = 0;
            hitEntity.setInvulnerable(false);
            hitEntity.hurtDuration = 0;
            hitEntity.hurtTime = 0;
            hitEntity.hurtMarked = false;
            player.setLastHurtMob(null);
            hitEntity.setLastHurtByMob(null);
            hitEntity.setLastHurtByPlayer(null);
            hitEntity.hurt(owner.level().damageSources().generic(), this.getArrowType().getAttackDamageBonus());
        } else if (hitEntity instanceof Player) {
            Player player2 = (Player)hitEntity;
            if (owner == null) {
                player2.invulnerableTime = 0;
                player2.setInvulnerable(false);
                player2.hurtDuration = 0;
                player2.hurtTime = 0;
                player2.hurtMarked = false;
                player2.setLastHurtMob(null);
                player2.setLastHurtByMob(null);
                player2.setLastHurtByPlayer(null);
                player2.hurt(player2.level().damageSources().generic(), this.getArrowType().getAttackDamageBonus());
            }
        }
        switch (this.getArrowType()) {
            case BLAZE_ROD: {
                hitEntity.setRemainingFireTicks(40);
                break;
            }
            case BONE: {
                hitEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 20, 1));
                break;
            }
            case COPPER: {
                LightningBolt lightningBolt;
                if (level.random.nextFloat() < 0.01f && level.isRainingAt(hitEntity.blockPosition().above())) {
                    lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                    lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)hitEntity.blockPosition().above()));
                    lightningBolt.setCause(null);
                    level.addFreshEntity((Entity)lightningBolt);
                }
                if (bow == null || bow.getBowType() != BowType.COPPER) break;
                lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)hitEntity.blockPosition().above()));
                lightningBolt.setCause(null);
                level.addFreshEntity((Entity)lightningBolt);
                break;
            }
            case ENDER_PEARL: {
                if (owner == null || arrow.level().isClientSide()) break;
                hitEntity.teleportTo((ServerLevel)owner.level(), owner.xo, owner.yo, owner.zo, RelativeMovement.ROTATION, hitEntity.getYRot(), hitEntity.getXRot());
                break;
            }
            case FLINT_AND_STEEL: {
                hitEntity.setRemainingFireTicks(40);
                break;
            }
            case FLINT: {
                if (bow == null || bow.getBowType() != BowType.IRON) break;
                hitEntity.setRemainingFireTicks(40);
                break;
            }
            case MOSS: {
                if (bow == null || bow.getBowType() != BowType.MOSS && bow.getBowType() != BowType.PAPER) break;
                IModArrow.paperArrowHitsEntity(owner, level, (Entity)hitEntity);
                break;
            }
            case PAPER: {
                if (bow == null || bow.getBowType() != BowType.PAPER && bow.getBowType() != BowType.MOSS) break;
                IModArrow.paperArrowHitsEntity(owner, level, (Entity)hitEntity);
                break;
            }
            case TNT: {
                level.explode(null, hitEntity.xo, hitEntity.yo + 1.0, hitEntity.zo, 2.0f, true, Level.ExplosionInteraction.TNT);
                arrow.discard();
            }
        }
    }

    private static void igniteBlockOnHit(BlockHitResult result, Level level, BlockPos pos, BlockState state) {
        if (!state.hasProperty((Property)BlockStateProperties.LIT)) {
            BlockPos relativePosition = pos.relative(result.getDirection());
            if (level.isEmptyBlock(relativePosition)) {
                level.setBlockAndUpdate(relativePosition, BaseFireBlock.getState((BlockGetter)level, (BlockPos)relativePosition));
            }
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private static void bambooArrowHitsBlock(Level level, BlockPos pos, BlockState state) {
        if (Blocks.BAMBOO.defaultBlockState().canSurvive((LevelReader)level, pos)) {
            if (Feature.isDirt((BlockState)state)) {
                level.setBlock(pos, Blocks.PODZOL.defaultBlockState(), 3);
                level.setBlock(pos.above(), Blocks.BAMBOO.defaultBlockState(), 3);
            } else if (state.is(Blocks.BAMBOO)) {
                level.setBlock(pos.above(), Blocks.BAMBOO.defaultBlockState(), 3);
            }
        }
    }

    private static void paperArrowHitsBlock(Entity owner, Level level, BlockPos pos) {
        Random random = new Random();
        switch (random.nextInt(1, 9)) {
            case 1: {
                level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2.0f, true, Level.ExplosionInteraction.TNT);
                break;
            }
            case 2: {
                if (owner == null) break;
                owner.teleportTo(owner.xo, owner.yo + 10.0, owner.zo);
                break;
            }
            case 3: {
                if (owner == null) break;
                owner.teleportTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                break;
            }
            case 4: {
                if (owner == null) break;
                owner.teleportTo((double)pos.getX(), (double)(pos.getY() + 10), (double)pos.getZ());
                break;
            }
            case 5: {
                LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos.above()));
                lightningBolt.setCause(null);
                level.addFreshEntity((Entity)lightningBolt);
                break;
            }
            case 6: {
                level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0f, true, Level.ExplosionInteraction.TNT);
                break;
            }
            case 7: {
                for (int i = 0; i < 4; ++i) {
                    Chicken chicken = (Chicken)EntityType.CHICKEN.create(level);
                    chicken.moveTo((double)pos.getX(), (double)(pos.getY() + i), (double)pos.getZ());
                    level.addFreshEntity((Entity)chicken);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < 4; ++i) {
                    Zombie zombie = (Zombie)EntityType.ZOMBIE.create(level);
                    zombie.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                    level.addFreshEntity((Entity)zombie);
                }
                break;
            }
        }
    }

    private static void paperArrowHitsEntity(Entity owner, Level level, Entity entity) {
        Random random = new Random();
        switch (random.nextInt(1, 9)) {
            case 1: {
                entity.setRemainingFireTicks(40);
                break;
            }
            case 2: {
                if (owner == null) break;
                entity.teleportTo(owner.xo, owner.yo, owner.zo);
                break;
            }
            case 3: {
                if (owner == null) break;
                owner.teleportTo(entity.xo, entity.yo, entity.zo);
                break;
            }
            case 4: {
                if (owner == null) break;
                entity.teleportTo(entity.xo, entity.yo + 10.0, entity.zo);
                break;
            }
            case 5: {
                LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)entity.blockPosition().above()));
                lightningBolt.setCause(null);
                level.addFreshEntity((Entity)lightningBolt);
                break;
            }
            case 6: {
                level.explode(null, entity.xo, entity.yo, entity.zo, 2.0f, true, Level.ExplosionInteraction.TNT);
                break;
            }
            case 7: {
                for (int i = 0; i < 4; ++i) {
                    Chicken chicken = (Chicken)EntityType.CHICKEN.create(level);
                    chicken.moveTo(entity.xo, entity.yo + (double)i, entity.zo);
                    level.addFreshEntity((Entity)chicken);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < 4; ++i) {
                    Zombie zombie = (Zombie)EntityType.ZOMBIE.create(level);
                    zombie.moveTo(entity.xo, entity.yo, entity.zo);
                    level.addFreshEntity((Entity)zombie);
                }
                break;
            }
        }
    }
}

