/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_bows_and_arrows.core.world.item;

import java.util.List;
import neoforge.com.cursee.more_bows_and_arrows.core.ModConfig;
import neoforge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.ModArrow;
import neoforge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import neoforge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.IModArrow;
import neoforge.com.cursee.more_bows_and_arrows.core.world.item.ModBowItem;
import neoforge.com.cursee.more_bows_and_arrows.core.world.item.util.BowType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ModArrowItem
extends ArrowItem
implements IModArrow {
    private final ArrowType type;

    public ModArrowItem(ArrowType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Override
    public ArrowType getArrowType() {
        return this.type;
    }

    public AbstractArrow createArrow(Level level, ItemStack ammo, LivingEntity shooter, @Nullable ItemStack weapon) {
        ModBowItem modBow;
        Item item;
        System.out.println("createArrow from ModArrowItem");
        ModArrow arrow = new ModArrow(this.type, shooter, level, weapon);
        if (this.type == ArrowType.BLAZE_ROD || (item = shooter.getMainHandItem().getItem()) instanceof ModBowItem && (modBow = (ModBowItem)item).getBowType() == BowType.BLAZE) {
            arrow.setRemainingFireTicks(1000);
        }
        return arrow;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ArrowType.appendHoverText(this.type, tooltipComponents);
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        return !ModConfig.BANNED_ARROWS.contains(this.type.name().toLowerCase() + "_arrow");
    }
}

