/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.block;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.client.Client;
import ht.treechop.common.block.BlockImitator;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.loot.TreeChopLootContextParams;
import ht.treechop.common.network.ServerUpdateChopsPacket;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.common.util.FaceShape;
import ht.treechop.server.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ChoppedLogBlock
extends BlockImitator
implements IChoppableBlock,
EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int DEFAULT_SUPPORT_FACTOR = 7;
    public static final int DEFAULT_MAX_NUM_CHOPS = 7;
    public static final int DEFAULT_UNCHOPPED_RADIUS = 8;

    public ChoppedLogBlock(BlockBehaviour.Properties properties) {
        super(properties.dynamicShape().isViewBlocking((blockState, level, pos) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public static ChoppedLogShape getPlacementShape(Level level, BlockPos blockPos, BlockState state) {
        boolean DOWN = true;
        int UP = 2;
        int NORTH = 4;
        int SOUTH = 8;
        int WEST = 16;
        int EAST = 32;
        byte openSides = (byte)((ChoppedLogBlock.isBlockOpen(level, blockPos.below()) ? 1 : 0) | (!ChopUtil.isBlockALog(level, blockPos.above()) ? 2 : 0) | (!ChopUtil.isBlockALog(level, blockPos.north()) ? 4 : 0) | (!ChopUtil.isBlockALog(level, blockPos.south()) ? 8 : 0) | (!ChopUtil.isBlockALog(level, blockPos.west()) ? 16 : 0) | (!ChopUtil.isBlockALog(level, blockPos.east()) ? 32 : 0));
        return ChoppedLogShape.forOpenSides(openSides);
    }

    private static boolean isBlockOpen(Level level, BlockPos pos) {
        return level.isEmptyBlock(pos) || ChopUtil.isBlockLeaves(level, pos);
    }

    @Override
    public BlockState getImitatedBlockState(BlockGetter level, BlockPos pos) {
        MyEntity entity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MyEntity && !(entity = (MyEntity)blockEntity).getOriginalState().is((Block)this)) {
            return entity.getOriginalState();
        }
        return Blocks.OAK_LOG.defaultBlockState();
    }

    public float getDestroyProgress(BlockState blockState, Player player, BlockGetter level, BlockPos pos) {
        return (float)Math.min(0.35, (double)this.getImitatedBlockState(level, pos).getDestroyProgress(player, level, pos));
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        double scale = 0.0625;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MyEntity) {
            MyEntity entity = (MyEntity)blockEntity;
            AABB box = entity.getShape().getBoundingBox(entity.getRadius());
            return Shapes.box((double)(box.minX * 0.0625), (double)(box.minY * 0.0625), (double)(box.minZ * 0.0625), (double)(box.maxX * 0.0625), (double)(box.maxY * 0.0625), (double)(box.maxZ * 0.0625));
        }
        return Shapes.block();
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        MyEntity entity;
        BlockEntity blockEntity;
        if (ConfigHandler.removeBarkOnInteriorLogs.get().booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof MyEntity && (entity = (MyEntity)blockEntity).getOriginalState().isSolidRender(level, pos)) {
            return entity.getOcclusionShape(level, pos);
        }
        return Shapes.empty();
    }

    public boolean useShapeForLightOcclusion(BlockState blockState) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @Override
    public int getNumChops(BlockGetter level, BlockPos pos, BlockState blockState) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MyEntity) {
            MyEntity entity = (MyEntity)blockEntity;
            n = entity.getChops();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public int getMaxNumChops(BlockGetter level, BlockPos pos, BlockState blockState) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MyEntity) {
            MyEntity entity = (MyEntity)blockEntity;
            return entity.getMaxNumChops();
        }
        return 7;
    }

    @Override
    public double getSupportFactor(BlockGetter level, BlockPos pos, BlockState blockState) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MyEntity) {
            MyEntity entity = (MyEntity)blockEntity;
            return entity.getSupportFactor();
        }
        return 7.0;
    }

    @Override
    public void chop(Player player, ItemStack tool, Level level, BlockPos pos, BlockState blockState, int numChops, boolean felling) {
        int currentNumChops = ChopUtil.getNumChops(level, pos, blockState);
        int maxNumChops = ChopUtil.getMaxNumChops(level, pos, blockState);
        int newNumChops = Math.min(currentNumChops + numChops, maxNumChops);
        int numAddedChops = newNumChops - currentNumChops;
        if (!felling) {
            if (numAddedChops > 0) {
                BlockEntity supportFactor2;
                if (!blockState.is((Block)this)) {
                    BlockEntity blockEntity;
                    BlockState newBlockState;
                    int chopZeroRadius = Optional.ofNullable(ClassUtil.getCylinderBlock(blockState.getBlock())).map(slimBlock -> slimBlock.getRadius((BlockGetter)level, pos, blockState)).orElse(8);
                    double supportFactor2 = Optional.ofNullable(ClassUtil.getFellableBlock(blockState.getBlock())).map(fellableBlock -> fellableBlock.getSupportFactor((BlockGetter)level, pos, blockState)).orElse(1.0);
                    BlockState blockState2 = newBlockState = blockState.is((Block)this) ? blockState : this.getPlacementState(level, pos);
                    if (level.setBlockAndUpdate(pos, newBlockState) && (blockEntity = level.getBlockEntity(pos)) instanceof MyEntity) {
                        MyEntity entity = (MyEntity)blockEntity;
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            entity.setShape(ChoppedLogBlock.getPlacementShape(level, pos, blockState));
                            entity.setOriginalState(blockState);
                            entity.setParameters(chopZeroRadius, maxNumChops, supportFactor2);
                            if (((Boolean)ConfigHandler.COMMON.dropLootOnFirstChop.get()).booleanValue()) {
                                Block.getDrops((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)entity, (Entity)player, (ItemStack)tool).forEach(stack -> ChoppedLogBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
                            }
                        }
                    }
                }
                if ((supportFactor2 = level.getBlockEntity(pos)) instanceof MyEntity) {
                    MyEntity entity = (MyEntity)supportFactor2;
                    entity.setChops(newNumChops);
                    entity.setChanged();
                }
            } else {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceLocation chopLootTableId = BuiltInRegistries.BLOCK.getKey((Object)this.asBlock()).withPrefix("chopping/");
            ResourceKey chopLootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)chopLootTableId);
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(chopLootTableKey);
            int finalBlockChopCount = currentNumChops + numAddedChops;
            for (int i = 0; i < numAddedChops; ++i) {
                int blockChopCount = 1 + currentNumChops + i;
                LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.BLOCK_STATE, (Object)this.defaultBlockState()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(TreeChopLootContextParams.BLOCK_CHOP_COUNT, (Object)blockChopCount).withParameter(TreeChopLootContextParams.DESTROY_BLOCK, (Object)(felling && blockChopCount == finalBlockChopCount ? 1 : 0)).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)level.getBlockEntity(pos));
                lootTable.getRandomItems(builder.create(TreeChopLootContextParams.SET)).forEach(stack -> ChoppedLogBlock.popResource((Level)serverLevel, (BlockPos)pos, (ItemStack)stack));
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getPlacementState(context.getLevel(), context.getClickedPos());
    }

    private BlockState getPlacementState(Level level, BlockPos pos) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(this.shouldPlaceAsWaterlogged(level, pos)));
    }

    private boolean shouldPlaceAsWaterlogged(Level level, BlockPos pos) {
        Direction[] waterSourceDirections = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP};
        return Arrays.stream(waterSourceDirections).filter(direction -> level.getFluidState(pos.offset(direction.getNormal())).isSource()).limit(2L).count() == 2L;
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public BlockState updateShape(BlockState blockState, Direction side, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof MyEntity) {
            MyEntity entity = (MyEntity)blockEntity;
            entity.rerender();
        }
        return super.updateShape(blockState, side, neighborState, level, pos, neighborPos);
    }

    @Nonnull
    public List<ItemStack> getDrops(BlockState blockState, LootParams.Builder context) {
        Object object;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(super.getDrops(blockState, context));
        if (((Boolean)ConfigHandler.COMMON.dropLootForChoppedBlocks.get()).booleanValue() && (object = context.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof MyEntity) {
            MyEntity entity = (MyEntity)((Object)object);
            ItemStack tool = (ItemStack)context.getOptionalParameter(LootContextParams.TOOL);
            Entity player = (Entity)context.getOptionalParameter(LootContextParams.THIS_ENTITY);
            stacks.addAll(Block.getDrops((BlockState)entity.originalState, (ServerLevel)context.getLevel(), (BlockPos)entity.getBlockPos(), (BlockEntity)entity, (Entity)player, (ItemStack)(tool == null ? ItemStack.EMPTY : tool)));
        }
        return stacks;
    }

    public static abstract class MyEntity
    extends BlockEntity {
        public static final String KEY_CHOPS = "Chops";
        public static final String KEY_SHAPE = "Shape";
        public static final String KEY_ORIGINAL_STATE = "OriginalState";
        public static final String KEY_UNCHOPPED_RADIUS = "UnchoppedRadius";
        public static final String KEY_MAX_NUM_CHOPS = "MaxNumChops";
        public static final String KEY_SUPPORT_FACTOR = "SupportFactor";
        protected BlockState originalState = Blocks.OAK_LOG.defaultBlockState();
        private ChoppedLogShape shape = ChoppedLogShape.PILLAR_Y;
        private int chops = 1;
        private int unchoppedRadius = 8;
        private int maxNumChops = 7;
        private double supportFactor = 7.0;

        public MyEntity(BlockPos pos, BlockState blockState) {
            super(TreeChop.platform.getChoppedLogBlockEntity(), pos, blockState);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.level, this.worldPosition, this.originalState, this.shape, this.chops, this.unchoppedRadius, this.maxNumChops, this.supportFactor});
        }

        public void setParameters(int unchoppedRadius, int maxNumChops, double supportFactor) {
            this.unchoppedRadius = unchoppedRadius;
            this.maxNumChops = maxNumChops;
            this.supportFactor = supportFactor;
        }

        public int getChops() {
            return this.chops;
        }

        public void setChops(int chops) {
            this.chops = chops;
        }

        public ChoppedLogShape getShape() {
            return this.shape;
        }

        public void setShape(ChoppedLogShape shape) {
            this.shape = shape;
        }

        public BlockState getOriginalState() {
            return this.originalState;
        }

        public void setOriginalState(BlockState originalState) {
            this.originalState = originalState;
        }

        public int getUnchoppedRadius() {
            return this.unchoppedRadius;
        }

        public int getRadius() {
            return Math.max(this.getUnchoppedRadius() - this.getChops(), 1);
        }

        public int getMaxNumChops() {
            return this.maxNumChops;
        }

        public double getSupportFactor() {
            return this.supportFactor;
        }

        public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider lookup) {
            super.saveAdditional(tag, lookup);
            tag.putInt(KEY_ORIGINAL_STATE, Block.getId((BlockState)this.getOriginalState()));
            tag.putInt(KEY_CHOPS, this.getChops());
            tag.putInt(KEY_SHAPE, this.getShape().ordinal());
            if (this.unchoppedRadius != 8) {
                tag.putInt(KEY_UNCHOPPED_RADIUS, this.unchoppedRadius);
            }
            if (this.maxNumChops != 7) {
                tag.putInt(KEY_MAX_NUM_CHOPS, this.maxNumChops);
            }
            if (this.supportFactor != 7.0) {
                tag.putDouble(KEY_SUPPORT_FACTOR, this.supportFactor);
            }
        }

        public void loadAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider lookup) {
            super.loadAdditional(tag, lookup);
            int hash = this.hashCode();
            int stateId = tag.getInt(KEY_ORIGINAL_STATE);
            this.setOriginalState(stateId > 0 ? Block.stateById((int)stateId) : Blocks.OAK_LOG.defaultBlockState());
            this.setChops(tag.getInt(KEY_CHOPS));
            this.setShape(ChoppedLogShape.values()[tag.getInt(KEY_SHAPE)]);
            int unchoppedRadius = tag.contains(KEY_UNCHOPPED_RADIUS) ? tag.getInt(KEY_UNCHOPPED_RADIUS) : 8;
            int maxNumChops = tag.contains(KEY_MAX_NUM_CHOPS) ? tag.getInt(KEY_MAX_NUM_CHOPS) : 7;
            double supportFactor = tag.contains(KEY_SUPPORT_FACTOR) ? (double)tag.getInt(KEY_SUPPORT_FACTOR) : 7.0;
            this.setParameters(unchoppedRadius, maxNumChops, supportFactor);
            if (hash != this.hashCode()) {
                this.rerenderNeighborhood();
            }
        }

        @Nonnull
        public CompoundTag getUpdateTag(HolderLookup.Provider lookup) {
            return this.saveWithoutMetadata(lookup);
        }

        @Nullable
        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }

        public void setChanged() {
            super.setChanged();
            this.syncWithClients();
        }

        private void syncWithClients() {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Server.instance().broadcast(serverLevel, this.worldPosition, new ServerUpdateChopsPacket(this.worldPosition, this.getUpdateTag((HolderLookup.Provider)this.level.registryAccess())));
            }
        }

        protected void rerender() {
            if (this.level != null && this.level.isClientSide()) {
                Minecraft.getInstance().levelRenderer.setBlockDirty(this.worldPosition, Blocks.AIR.defaultBlockState(), this.getBlockState());
                Client.treeCache.invalidate();
            }
        }

        private void rerenderNeighborhood() {
            if (this.level != null && this.level.isClientSide()) {
                this.rerender();
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                for (Direction dir : Direction.values()) {
                    pos.setWithOffset((Vec3i)this.worldPosition, dir);
                    BlockEntity blockEntity = this.level.getBlockEntity((BlockPos)pos);
                    if (!(blockEntity instanceof MyEntity)) continue;
                    MyEntity neighbor = (MyEntity)blockEntity;
                    neighbor.rerender();
                }
            }
        }

        public Stream<Direction> streamSolidSides(BlockGetter level, BlockPos pos) {
            return ConfigHandler.removeBarkOnInteriorLogs.get() != false ? Arrays.stream(Direction.values()).filter(direction -> !this.shape.isSideOpen((Direction)direction)).filter(direction -> {
                BlockState blockState;
                BlockPos neighborPos = pos.relative(direction);
                return ChopUtil.isBlockChoppable(level, neighborPos, blockState = level.getBlockState(neighborPos)) && blockState.isCollisionShapeFullBlock(level, neighborPos);
            }) : Stream.empty();
        }

        public VoxelShape getOcclusionShape(BlockGetter level, BlockPos pos) {
            return Shapes.or((VoxelShape)Shapes.empty(), (VoxelShape[])((VoxelShape[])this.streamSolidSides(level, pos).map(direction -> Shapes.create((AABB)FaceShape.get(direction).toAABB())).toArray(VoxelShape[]::new)));
        }
    }
}

