/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.pathfinder.Path;

public class FindFavouriteFoodGoal
extends Goal {
    private ItemEntity itemEntity;
    private final AbstractGoblinEntity goblin;

    public FindFavouriteFoodGoal(AbstractGoblinEntity goblin) {
        this.goblin = goblin;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.findFavouriteFood();
        if (this.itemEntity == null || !this.itemEntity.isAlive()) {
            return false;
        }
        Path path = this.goblin.getNavigation().createPath((Entity)this.itemEntity, 0);
        if (path == null || !path.canReach()) {
            return false;
        }
        return !this.goblin.isStunned();
    }

    public void tick() {
        if (this.goblin.isStunned()) {
            return;
        }
        this.goblin.getLookControl().setLookAt((Entity)this.itemEntity, 10.0f, (float)this.goblin.getHeadRotSpeed());
        this.goblin.getNavigation().stop();
        Path path = this.goblin.getNavigation().createPath((Entity)this.itemEntity, 0);
        if (path != null) {
            this.goblin.getNavigation().moveTo(path, (double)0.4f);
        }
        if ((double)this.goblin.distanceTo((Entity)this.itemEntity) <= 1.0 && this.itemEntity.isAlive()) {
            this.itemEntity.remove(Entity.RemovalReason.KILLED);
            this.goblin.level().playSound(null, this.itemEntity.getX(), this.itemEntity.getY(), this.itemEntity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 1.0f, 0.75f);
            this.goblin.setItemSlot(EquipmentSlot.MAINHAND, this.goblin.getFavouriteFood().copy());
        }
    }

    public boolean canContinueToUse() {
        return this.itemEntity.isAlive() && this.goblin.getNavigation().createPath((Entity)this.itemEntity, 0) != null && this.goblin.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
    }

    private void findFavouriteFood() {
        List players = this.goblin.level().getEntitiesOfClass(ItemEntity.class, this.goblin.getBoundingBox().inflate(10.0), itemEntity -> itemEntity.getItem().getItem() == this.goblin.getFavouriteFood().getItem());
        if (!players.isEmpty()) {
            this.itemEntity = players.stream().min(Comparator.comparing(arg_0 -> ((AbstractGoblinEntity)this.goblin).distanceTo(arg_0))).get();
        }
    }
}

