/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class FollowPotentialCustomerGoal
extends Goal {
    private static final int FOLLOW_TIME = 200;
    private final AbstractGoblinEntity goblin;
    private Player potentialCustomer;
    private int coolDown = 0;
    private int timeout = 200;

    public FollowPotentialCustomerGoal(AbstractGoblinEntity goblin) {
        this.goblin = goblin;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.goblin.getTradingPlayer() != null) {
            return false;
        }
        if (this.goblin.isStunned()) {
            return false;
        }
        if (this.goblin.isLeashed()) {
            return false;
        }
        if (this.coolDown > 0) {
            --this.coolDown;
            return false;
        }
        this.findCustomer();
        return this.potentialCustomer != null && this.potentialCustomer.isAlive() && !this.goblin.isPreviousCustomer(this.potentialCustomer);
    }

    public void tick() {
        this.goblin.getLookControl().setLookAt((Entity)this.potentialCustomer, 20.0f, (float)this.goblin.getHeadRotSpeed());
        if ((double)this.goblin.distanceTo((Entity)this.potentialCustomer) >= 2.0) {
            this.goblin.getNavigation().moveTo((Entity)this.potentialCustomer, 1.0);
        }
        --this.timeout;
    }

    public boolean canContinueToUse() {
        return this.potentialCustomer != null && this.potentialCustomer.isAlive() && this.goblin.getTradingPlayer() == null && !this.goblin.isPreviousCustomer(this.potentialCustomer) && (double)this.goblin.distanceTo((Entity)this.potentialCustomer) <= 10.0 && this.timeout > 0 && !this.goblin.isLeashed();
    }

    public void stop() {
        this.goblin.getNavigation().stop();
        this.potentialCustomer = null;
        this.timeout = 200;
        this.coolDown = 200;
    }

    private void findCustomer() {
        List players = this.goblin.level().getEntitiesOfClass(Player.class, this.goblin.getBoundingBox().inflate(10.0), playerEntity -> !playerEntity.isSpectator());
        if (!players.isEmpty()) {
            this.potentialCustomer = players.stream().min(Comparator.comparing(arg_0 -> ((AbstractGoblinEntity)this.goblin).distanceTo(arg_0))).get();
        }
    }
}

