/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.stream.Stream;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.RenderLayerEnum;
import snownee.kiwi.loader.event.InitEvent;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.ExtraCollisionSnowLayerBlock;
import snownee.snow.block.SRMSnowLayerBlock;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowFenceGateBlock;
import snownee.snow.block.SnowSlabBlock;
import snownee.snow.block.SnowStairsBlock;
import snownee.snow.block.SnowWallBlock;
import snownee.snow.block.WaterLoggableSnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.block.entity.SnowCoveredBlockEntity;
import snownee.snow.convert.BlockConverters;
import snownee.snow.loot.NormalizeLoot;
import snownee.snow.mixin.BlockBehaviourAccess;

@KiwiModule(modId="snowrealmagic")
public class CoreModule
extends AbstractModule {
    public static final TagKey<Block> SNOW_TAG = CoreModule.blockTag((String)"snow");
    public static final TagKey<Block> SNOWY_SETTING = CoreModule.blockTag((String)"snowy_setting");
    public static final TagKey<Block> CONTAINABLES = CoreModule.blockTag((String)"containables");
    public static final TagKey<Block> PLANTS = CoreModule.blockTag((String)"plants");
    public static final TagKey<Block> NOT_CONTAINABLES = CoreModule.blockTag((String)"not_containables");
    public static final TagKey<Block> ENTITY_INSIDE = CoreModule.blockTag((String)"entity_inside");
    public static final TagKey<Block> OFFSET_Y = CoreModule.blockTag((String)"offset_y");
    public static final TagKey<Block> EXPAND_MODEL = CoreModule.blockTag((String)"expand_model");
    public static final TagKey<Block> CANNOT_ACCUMULATE_ON = CoreModule.blockTag((String)"cannot_accumulate_on");
    @KiwiModule.NoItem
    @KiwiModule.Name(value="snow_extra_collision")
    public static final KiwiGO<SRMSnowLayerBlock> SNOW_EXTRA_COLLISION_BLOCK = CoreModule.go(() -> new ExtraCollisionSnowLayerBlock(CoreModule.blockProp((BlockBehaviour)Blocks.SNOW).dynamicShape()));
    @KiwiModule.NoItem
    @KiwiModule.Name(value="snow")
    public static final KiwiGO<SRMSnowLayerBlock> SNOW_BLOCK = CoreModule.go(() -> new SRMSnowLayerBlock(CoreModule.blockProp((BlockBehaviour)Blocks.SNOW).dynamicShape()));
    @KiwiModule.NoItem
    public static final KiwiGO<SRMSnowLayerBlock> SNOWY_PLANT = CoreModule.go(() -> new SRMSnowLayerBlock(CoreModule.blockProp((BlockBehaviour)Blocks.SNOW).dynamicShape()));
    @KiwiModule.NoItem
    public static final KiwiGO<SRMSnowLayerBlock> SNOWY_DOUBLE_PLANT_LOWER = CoreModule.go(() -> new SRMSnowLayerBlock(CoreModule.blockProp((BlockBehaviour)Blocks.SNOW).dynamicShape()));
    @KiwiModule.NoItem
    public static final KiwiGO<SRMSnowLayerBlock> SNOWY_DOUBLE_PLANT_UPPER = CoreModule.go(() -> new SRMSnowLayerBlock(CoreModule.blockProp((BlockBehaviour)Blocks.SNOW).dynamicShape()));
    @KiwiModule.NoItem
    @KiwiModule.RenderLayer(value=RenderLayerEnum.CUTOUT)
    public static final KiwiGO<Block> FENCE = CoreModule.go(() -> new SnowFenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.OAK_FENCE).mapColor(MapColor.SNOW).sound(SoundType.SNOW).randomTicks()));
    @KiwiModule.NoItem
    @KiwiModule.RenderLayer(value=RenderLayerEnum.CUTOUT)
    public static final KiwiGO<Block> FENCE2 = CoreModule.go(() -> new SnowFenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.NETHER_BRICK_FENCE).mapColor(MapColor.SNOW).sound(SoundType.SNOW).randomTicks()));
    @KiwiModule.NoItem
    @KiwiModule.RenderLayer(value=RenderLayerEnum.CUTOUT)
    public static final KiwiGO<Block> STAIRS = CoreModule.go(() -> new SnowStairsBlock(CoreModule.blockProp((BlockBehaviour)Blocks.OAK_STAIRS).mapColor(MapColor.SNOW).sound(SoundType.SNOW).randomTicks()));
    @KiwiModule.NoItem
    @KiwiModule.RenderLayer(value=RenderLayerEnum.CUTOUT)
    public static final KiwiGO<Block> SLAB = CoreModule.go(() -> new SnowSlabBlock(CoreModule.blockProp((BlockBehaviour)Blocks.OAK_SLAB).mapColor(MapColor.SNOW).sound(SoundType.SNOW).randomTicks()));
    @KiwiModule.NoItem
    @KiwiModule.RenderLayer(value=RenderLayerEnum.CUTOUT)
    public static final KiwiGO<Block> FENCE_GATE = CoreModule.go(() -> new SnowFenceGateBlock(CoreModule.blockProp((BlockBehaviour)Blocks.OAK_FENCE_GATE).mapColor(MapColor.SNOW).sound(SoundType.SNOW).randomTicks()));
    @KiwiModule.NoItem
    @KiwiModule.RenderLayer(value=RenderLayerEnum.CUTOUT)
    public static final KiwiGO<Block> WALL = CoreModule.go(() -> new SnowWallBlock(CoreModule.blockProp((BlockBehaviour)Blocks.COBBLESTONE_WALL).mapColor(MapColor.SNOW).sound(SoundType.SNOW).randomTicks()));
    @KiwiModule.Name(value="snow")
    public static final KiwiGO<BlockEntityType<SnowBlockEntity>> TILE = CoreModule.blockEntity(SnowBlockEntity::new, null, SRMSnowLayerBlock.class);
    public static final KiwiGO<BlockEntityType<SnowCoveredBlockEntity>> TEXTURE_TILE = CoreModule.blockEntity(SnowCoveredBlockEntity::new, null, WaterLoggableSnowVariant.class);
    public static final KiwiGO<LootPoolEntryType> NORMALIZE = CoreModule.go(() -> new LootPoolEntryType(NormalizeLoot.CODEC));
    public static final GameRules.Key<GameRules.IntegerValue> BLIZZARD_STRENGTH = GameRuleRegistry.register((String)"snowrealmagic:blizzardStrength", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.create((int)0));
    public static final GameRules.Key<GameRules.IntegerValue> BLIZZARD_FREQUENCY = GameRuleRegistry.register((String)"snowrealmagic:blizzardFrequency", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.create((int)10000));
    public static final BlockConverters CONVERTERS = new BlockConverters();

    protected void init(InitEvent event) {
        event.enqueueWork(() -> {
            CONVERTERS.initSnow();
            BlockBehaviour.StateArgumentPredicate predicate = (blockState, blockGetter, blockPos, entityType) -> {
                BlockPos below = blockPos.below();
                return (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS) <= SnowCommonConfig.mobSpawningMaxLayers && blockGetter.getBlockState(below).isValidSpawn(blockGetter, below, entityType);
            };
            Stream.of(SNOW_EXTRA_COLLISION_BLOCK, SNOWY_DOUBLE_PLANT_LOWER, SNOWY_DOUBLE_PLANT_UPPER, SNOW_BLOCK, SNOWY_PLANT).map(KiwiGO::get).forEach(block -> {
                Item.BY_BLOCK.put(block, Items.SNOW);
                ((BlockBehaviourAccess)((Object)block)).getProperties().isValidSpawn(predicate);
            });
            ((BlockBehaviourAccess)Blocks.SNOW).getProperties().isValidSpawn(predicate);
        });
    }
}

