/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.RenderLayerEnum;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.block.ShapeCaches;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.mixin.BlockBehaviourAccess;

@KiwiModule.RenderLayer(value=RenderLayerEnum.CUTOUT)
@NotNullByDefault
public class SRMSnowLayerBlock
extends SnowLayerBlock
implements EntityBlock,
BonemealableBlock,
SnowVariant {
    public SRMSnowLayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SnowBlockEntity(pos, state);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ShapeCaches.get(ShapeCaches.VISUAL, state, worldIn, pos, () -> {
            VoxelShape shape = super.getVisualShape(state, worldIn, pos, context);
            return Shapes.or((VoxelShape)shape, (VoxelShape)this.srm$getRaw(state, worldIn, pos).getVisualShape(worldIn, pos, context));
        });
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ShapeCaches.get(ShapeCaches.OUTLINE, state, worldIn, pos, () -> {
            VoxelShape shape = super.getShape(state, worldIn, pos, context);
            return Shapes.or((VoxelShape)shape, (VoxelShape)this.srm$getRaw(state, worldIn, pos).getShape(worldIn, pos, context));
        });
    }

    public VoxelShape getOcclusionShape(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return super.getShape(p_60578_, p_60579_, p_60580_, CollisionContext.empty());
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext useContext) {
        if ((Integer)blockState.getValue((Property)LAYERS) == 8) {
            return false;
        }
        if (useContext.getItemInHand().is(Items.SNOW)) {
            return super.canBeReplaced(blockState, useContext);
        }
        if (super.canBeReplaced(blockState, useContext)) {
            return true;
        }
        Level level = useContext.getLevel();
        BlockPos pos = useContext.getClickedPos();
        return this.srm$getRaw(blockState, (BlockGetter)level, pos).canBeReplaced(useContext);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState containedNew;
        BlockState contained;
        BlockState state = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!(worldIn instanceof WorldGenLevel) && state.getBlock() instanceof SRMSnowLayerBlock && (contained = this.srm$getRaw(state, (BlockGetter)worldIn, currentPos)) != (containedNew = contained.updateShape(facing, facingState, worldIn, currentPos, facingPos))) {
            if (containedNew.isAir()) {
                return this.srm$getSnowState(stateIn, (BlockGetter)worldIn, currentPos);
            }
            SRMSnowLayerBlock.setContainedState(worldIn, currentPos, containedNew);
        }
        return state;
    }

    public static void setContainedState(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SnowBlockEntity) {
            SnowBlockEntity be = (SnowBlockEntity)blockEntity;
            be.setContainedState(state);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack itemStack) {
        Hooks.processFancyOverlay((LevelAccessor)level, pos, itemStack);
    }

    public String getDescriptionId() {
        return Blocks.SNOW.getDescriptionId();
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockState blockState = this.srm$getRaw(state, (BlockGetter)worldIn, pos);
        Block block = blockState.getBlock();
        if (blockState.is(CoreModule.ENTITY_INSIDE)) {
            try {
                ((BlockBehaviourAccess)block).callEntityInside(blockState, worldIn, pos, entityIn);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockState stateIn = this.srm$getRaw(state, (BlockGetter)worldIn, pos);
        try {
            super.randomTick(state, worldIn, pos, random);
        }
        catch (Throwable e) {
            return;
        }
        if (stateIn.getBlock() instanceof TallGrassBlock || stateIn.getBlock() instanceof DoublePlantBlock) {
            return;
        }
        BlockState stateNow = worldIn.getBlockState(pos);
        if (!stateNow.is((Block)this)) {
            return;
        }
        try {
            stateIn.randomTick(worldIn, pos, random);
            BlockState stateNow2 = worldIn.getBlockState(pos);
            if (!stateNow2.is((Block)this)) {
                Hooks.convert((LevelAccessor)worldIn, pos, stateNow2, (Integer)stateNow.getValue((Property)LAYERS), 18, true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        try {
            InteractionResult result = this.srm$getRaw(blockState, (BlockGetter)level, blockPos).useWithoutItem(level, player, blockHitResult);
            if (result.consumesAction()) {
                BlockState stateNow = level.getBlockState(blockPos);
                if (!stateNow.is((Block)this)) {
                    Hooks.convert((LevelAccessor)level, blockPos, stateNow, (Integer)blockState.getValue((Property)LAYERS), 18, true);
                }
                return result;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        try {
            ItemInteractionResult result = this.srm$getRaw(blockState, (BlockGetter)level, blockPos).useItemOn(itemStack, level, player, interactionHand, blockHitResult);
            if (result.consumesAction()) {
                BlockState stateNow = level.getBlockState(blockPos);
                if (!stateNow.is((Block)this)) {
                    Hooks.convert((LevelAccessor)level, blockPos, stateNow, (Integer)blockState.getValue((Property)LAYERS), 18, true);
                }
                return result;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void attack(BlockState state, Level worldIn, BlockPos pos, Player player) {
        if (worldIn.isClientSide) {
            return;
        }
        try {
            BlockState contained = this.srm$getRaw(state, (BlockGetter)worldIn, pos);
            if (!contained.isAir() && contained.getDestroySpeed((BlockGetter)worldIn, pos) == 0.0f) {
                worldIn.levelEvent(2001, pos, Block.getId((BlockState)contained));
                Block.dropResources((BlockState)contained, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)ItemStack.EMPTY);
                int layers = (Integer)state.getValue((Property)LAYERS);
                worldIn.setBlockAndUpdate(pos, (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers)));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        BlockState contained = this.srm$getRaw(blockState, (BlockGetter)levelReader, blockPos);
        Block block = contained.getBlock();
        return block instanceof BonemealableBlock && ((BonemealableBlock)block).isValidBonemealTarget(levelReader, blockPos, contained);
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        BlockState contained = this.srm$getRaw(state, (BlockGetter)worldIn, pos);
        Block block = contained.getBlock();
        return block instanceof BonemealableBlock && ((BonemealableBlock)block).isBonemealSuccess(worldIn, rand, pos, contained);
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        BlockState contained = this.srm$getRaw(state, (BlockGetter)worldIn, pos);
        Block block = contained.getBlock();
        if (block instanceof BonemealableBlock) {
            ((BonemealableBlock)block).performBonemeal(worldIn, rand, pos, contained);
            BlockState stateNow = worldIn.getBlockState(pos);
            Hooks.convert((LevelAccessor)worldIn, pos, stateNow, (Integer)state.getValue((Property)LAYERS), 3, true);
        }
    }

    public Item asItem() {
        return Items.SNOW;
    }

    protected boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    protected int getLightBlock(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 0;
    }
}

