/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import snownee.snow.CoreModule;
import snownee.snow.block.entity.SnowBlockEntity;

public class NormalizeLoot
extends LootPoolSingletonContainer {
    public static final MapCodec<NormalizeLoot> CODEC = RecordCodecBuilder.mapCodec(instance -> NormalizeLoot.singletonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, NormalizeLoot::new));

    private NormalizeLoot(int weightIn, int qualityIn, List<LootItemCondition> conditionsIn, List<LootItemFunction> functionsIn) {
        super(weightIn, qualityIn, conditionsIn, functionsIn);
    }

    public static LootPoolSingletonContainer.Builder<?> builder() {
        return NormalizeLoot.simpleBuilder(NormalizeLoot::new);
    }

    protected void createItemStack(Consumer<ItemStack> consumer, LootContext context) {
        ResourceKey lootTable;
        BlockState state;
        BlockEntity tile = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof SnowBlockEntity && !(state = ((SnowBlockEntity)tile).getContainedState()).isAir() && (lootTable = state.getBlock().getLootTable()) != BuiltInLootTables.EMPTY) {
            LootParams.Builder builder = new LootParams.Builder(context.getLevel());
            builder.withParameter(LootContextParams.BLOCK_STATE, (Object)state);
            context.params.params.forEach((p, v) -> {
                if (p != LootContextParams.BLOCK_STATE && p != LootContextParams.BLOCK_ENTITY) {
                    builder.withOptionalParameter(p, v);
                }
            });
            builder.withLuck(context.getLuck());
            state.getDrops(builder).forEach(consumer);
        }
    }

    @NotNull
    public LootPoolEntryType getType() {
        return (LootPoolEntryType)CoreModule.NORMALIZE.get();
    }
}

