/*
 * Decompiled with CFR 0.152.
 */
package com.axedgaming.endersdelight.blocks.custom;

import com.axedgaming.endersdelight.blocks.custom.CustomBushBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class ChorusFlameBlock
extends CustomBushBlock {
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;

    public ChorusFlameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) < 2;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int currentAge = (Integer)pState.getValue((Property)AGE);
        if (currentAge < 2 && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState newState = (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(currentAge + 1));
            pLevel.setBlock(pPos, newState, 2);
            CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((BlockState)newState));
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.getValue((Property)AGE);
        switch (age) {
            case 0: {
                return Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
            }
            case 1: {
                return Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
            }
            case 2: {
                return Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
            }
        }
        return Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    }
}

