/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.events;

import com.soytutta.mynethersdelight.common.enchantment.PoachingData;
import com.soytutta.mynethersdelight.common.enchantment.PoachingFailureCase;
import com.soytutta.mynethersdelight.common.enchantment.PoachingFailureRegistry;
import com.soytutta.mynethersdelight.common.registry.MNDEnchantmentComponents;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import com.soytutta.mynethersdelight.common.utility.EntityDropChanceAccessor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ModTags;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class CommonEvent {
    @SubscribeEvent
    public static void livingDie(LivingDeathEvent event) {
        Mob mob;
        LivingEntity livingEntity;
        block26: {
            block25: {
                if (event.getEntity().level().isClientSide || !((livingEntity = event.getEntity()) instanceof Mob)) break block25;
                mob = (Mob)livingEntity;
                if (event.getSource() != null && (livingEntity = event.getSource().getDirectEntity()) instanceof LivingEntity) break block26;
            }
            return;
        }
        LivingEntity directSource = livingEntity;
        ItemStack weapon = directSource.getItemInHand(InteractionHand.MAIN_HAND);
        if (!weapon.is(ItemTags.WEAPON_ENCHANTABLE)) {
            return;
        }
        if (EnchantmentHelper.has((ItemStack)weapon, MNDEnchantmentComponents.POACHING.get()) && (mob.getMaxHealth() < 150.0f || mob.getType().is(MNDTags.SPECIAL_HUNT)) && ((directSource.hasEffect(MobEffects.LUCK) || directSource.hasEffect(MobEffects.UNLUCK)) && mob.level().random.nextFloat() < 0.6f || weapon.is(ModTags.KNIVES) || mob.level().random.nextFloat() < 0.4f)) {
            Level newMob2;
            boolean isFail;
            Slime slime;
            TieredItem tiered;
            Item item;
            ServerPlayer player;
            if (!(!(directSource instanceof ServerPlayer) || (player = (ServerPlayer)directSource).isCreative() || (item = weapon.getItem()) instanceof TieredItem && (tiered = (TieredItem)item).getTier() == Tiers.GOLD)) {
                int extraDamage = player.getRandom().nextInt(6) + 4;
                weapon.hurtAndBreak(extraDamage, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            if (mob instanceof Slime && (slime = (Slime)mob).getSize() > 1) {
                for (int i = 0; i < 2; ++i) {
                    Entity entity = mob.getType().create(mob.level());
                    if (!(entity instanceof Slime)) continue;
                    Slime mobCopy = (Slime)entity;
                    mobCopy.setSize(slime.getSize() - 1, true);
                    mobCopy.moveTo(mob.getX() + (double)i, mob.getY(), mob.getZ() + (double)i, mob.getYRot(), mob.getXRot());
                    mob.level().addFreshEntity((Entity)mobCopy);
                }
                return;
            }
            PoachingData poachingData = EnchantmentHelper.pickHighestLevel((ItemStack)weapon, MNDEnchantmentComponents.POACHING.get()).orElse(PoachingData.DEFAULT);
            Difficulty difficulty = event.getEntity().level().getDifficulty();
            float baseFailProbability = switch (difficulty) {
                default -> poachingData.defaultProbability();
                case Difficulty.PEACEFUL -> poachingData.peacefulProbability();
                case Difficulty.EASY -> poachingData.easyProbability();
                case Difficulty.NORMAL -> poachingData.normalProbability();
                case Difficulty.HARD -> poachingData.hardProbability();
            };
            int luckLevel = directSource.hasEffect(MobEffects.LUCK) ? directSource.getEffect(MobEffects.LUCK).getAmplifier() + 1 : 0;
            int badLuckLevel = directSource.hasEffect(MobEffects.UNLUCK) ? directSource.getEffect(MobEffects.UNLUCK).getAmplifier() + 1 : 0;
            float failProbability = baseFailProbability - (float)luckLevel * 0.1f + (float)badLuckLevel * 0.2f;
            boolean bl = isFail = (mob.level().random.nextFloat() < failProbability || mob.isBaby() && mob.level().random.nextFloat() < 0.2f || weapon.is(ModTags.KNIVES)) && !mob.hasEffect(MobEffects.CONFUSION);
            if (isFail) {
                Optional<PoachingFailureCase> failureCaseOpt = PoachingFailureRegistry.findCaseFor(mob, weapon);
                if (failureCaseOpt.isPresent()) {
                    PoachingFailureCase failureCase = failureCaseOpt.get();
                    Mob newMob2 = (Mob)failureCase.getTargetType().create(mob.level());
                    if (newMob2 != null) {
                        mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), failureCase.getTransformSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        Level level = mob.level();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, mob.getX(), mob.getY(0.5), mob.getZ(), 25, 0.5, 0.5, 0.5, 0.05);
                        }
                        failureCase.getSetupAction().accept(mob, newMob2);
                        newMob2.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                        newMob2.setYHeadRot(mob.getYHeadRot());
                        newMob2.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 600, 0));
                        mob.level().addFreshEntity((Entity)newMob2);
                        event.setCanceled(true);
                        mob.discard();
                    }
                    return;
                }
                mob.addTag("prevent_drops");
                mob.level().getEntitiesOfClass(Mob.class, mob.getBoundingBox().inflate(10.0)).stream().filter(nearby -> nearby.getType() == mob.getType()).forEach(nearby -> {
                    mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), (Holder)SoundEvents.SOUL_ESCAPE, SoundSource.PLAYERS, 0.5f, 1.0f);
                    nearby.hurt(event.getSource(), 0.0f);
                });
                return;
            }
            PiglinBrute Hunter = (PiglinBrute)EntityType.PIGLIN_BRUTE.create(mob.level());
            if (Hunter != null && (newMob2 = mob.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)newMob2;
                List<Object> lootToDrop = Collections.emptyList();
                if (mob.isBaby()) {
                    hunterDamage = mob.level().damageSources().mobAttack((LivingEntity)Hunter);
                    Mob adultCopy = (Mob)mob.getType().create((Level)serverLevel);
                    if (adultCopy != null) {
                        CompoundTag nbt = new CompoundTag();
                        mob.save(nbt);
                        adultCopy.load(nbt);
                        if (adultCopy instanceof AgeableMob) {
                            AgeableMob ageableCopy = (AgeableMob)adultCopy;
                            ageableCopy.setBaby(false);
                        }
                        EntityDropChanceAccessor adultCopyAcc = (EntityDropChanceAccessor)adultCopy;
                        lootToDrop = adultCopyAcc.callGenerateLoot(hunterDamage);
                        adultCopy.remove(Entity.RemovalReason.DISCARDED);
                    }
                } else {
                    ItemStack knife = new ItemStack((ItemLike)ModItems.FLINT_KNIFE.get());
                    EnchantmentHelper.setEnchantments((ItemStack)knife, (ItemEnchantments)weapon.getTagEnchantments());
                    EnchantmentHelper.updateEnchantments((ItemStack)knife, enchants -> enchants.removeIf(e -> e.is(MNDTags.POACHING_ENCHANTMENT)));
                    Hunter.setItemInHand(InteractionHand.MAIN_HAND, knife);
                    hunterDamage = mob.level().damageSources().mobAttack((LivingEntity)Hunter);
                    EntityDropChanceAccessor acc = (EntityDropChanceAccessor)mob;
                    lootToDrop = acc.callGenerateLoot(hunterDamage);
                }
                for (ItemStack stack : lootToDrop) {
                    mob.spawnAtLocation(stack);
                }
                mob.addTag("prevent_drops");
                Hunter.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @SubscribeEvent
    public static void onMobDrop(LivingDropsEvent event) {
        Mob mob;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).getTags().contains("prevent_drops")) {
            event.getDrops().clear();
        }
    }

    public static void transferBasicMobData(Mob original, Mob newMob) {
        if (original.hasCustomName()) {
            newMob.setCustomName(original.getCustomName());
            newMob.setCustomNameVisible(original.isCustomNameVisible());
        }
        if (original.isPersistenceRequired()) {
            newMob.setPersistenceRequired();
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            newMob.setItemSlot(slot, original.getItemBySlot(slot).copy());
        }
        original.getActiveEffects().forEach(effect -> newMob.addEffect(new MobEffectInstance(effect)));
        if (original.isNoAi()) {
            newMob.setNoAi(true);
        }
        if (original.isBaby()) {
            newMob.setBaby(true);
        }
    }

    public static void makeHostile(Mob mobToAnger, LivingEntity target) {
        if (target == null) {
            return;
        }
        if (mobToAnger instanceof NeutralMob) {
            NeutralMob neutralMob = (NeutralMob)mobToAnger;
            neutralMob.setPersistentAngerTarget(target.getUUID());
            neutralMob.startPersistentAngerTimer();
        }
        mobToAnger.setTarget(target);
    }

    public static void transferDataAndMakeHostile(Mob original, Mob newMob) {
        CommonEvent.transferBasicMobData(original, newMob);
        CommonEvent.makeHostile(newMob, original.getLastHurtByMob());
    }

    public static void transferFullHorseData(AbstractHorse original, AbstractHorse newHorse) {
        CompoundTag nbt = new CompoundTag();
        original.addAdditionalSaveData(nbt);
        nbt.remove("UUID");
        nbt.remove("Health");
        newHorse.readAdditionalSaveData(nbt);
        CommonEvent.transferBasicMobData((Mob)original, (Mob)newHorse);
    }
}

