/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.soytutta.mynethersdelight.common.block.feasts.BreadLoafBlock;
import com.soytutta.mynethersdelight.common.block.feasts.MagmaCakeBlock;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class MNDEspecialLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<MNDEspecialLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> MNDEspecialLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("drop").forGetter(m -> m.especialDrop)).apply((Applicative)inst, MNDEspecialLootModifier::new)));
    private final Item especialDrop;

    protected MNDEspecialLootModifier(LootItemCondition[] conditionsIn, Item especialDropIn) {
        super(conditionsIn);
        this.especialDrop = especialDropIn;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state != null) {
            Block targetBlock = state.getBlock();
            if (targetBlock instanceof MagmaCakeBlock) {
                int bites = (Integer)state.getValue((Property)MagmaCakeBlock.BITES);
                int count = (Boolean)state.getValue((Property)MagmaCakeBlock.SECOND_CAKE) != false ? 14 - bites : 7 - bites;
                generatedLoot.add((Object)new ItemStack((ItemLike)this.especialDrop, count));
            } else if (targetBlock instanceof BreadLoafBlock) {
                int bites = (Integer)state.getValue((Property)BreadLoafBlock.BITES);
                generatedLoot.add((Object)new ItemStack((ItemLike)this.especialDrop, 5 - bites));
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

