/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.color;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.gson.annotations.Since;
import java.util.Comparator;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.block.BiomeMD;

public class BiomeColor
implements Comparable<BiomeColor> {
    @Since(value=6.0)
    public String biome;
    @Since(value=6.0)
    public String grassColor;
    @Since(value=6.0)
    public String fogColor;
    @Since(value=6.0)
    public String foliageColor;
    @Since(value=6.0)
    public String waterColor;

    BiomeColor(BiomeMD biomeMD, Integer grassColor, Integer fogColor, Integer foliageColor, Integer waterColor) {
        this(biomeMD.getBiomeId(), grassColor, fogColor, foliageColor, waterColor);
    }

    BiomeColor(String biomeId, Integer grassColor, Integer fogColor, Integer foliageColor, Integer waterColor) {
        this(biomeId, RGB.toHexStringRGBA(grassColor), RGB.toHexStringRGBA(fogColor), RGB.toHexStringRGBA(foliageColor), RGB.toHexStringRGBA(waterColor));
    }

    BiomeColor(String biomeId, String grassColor, String fogColor, String foliageColor, String waterColor) {
        this.biome = biomeId;
        this.grassColor = grassColor;
        this.fogColor = fogColor;
        this.foliageColor = foliageColor;
        this.waterColor = waterColor;
    }

    BiomeColor(BiomeColor biomeColor) {
        this.biome = biomeColor.biome;
        this.grassColor = biomeColor.grassColor;
        this.fogColor = biomeColor.fogColor;
        this.foliageColor = biomeColor.foliageColor;
        this.waterColor = biomeColor.waterColor;
    }

    public String getColor(Effect effect) {
        switch (effect.ordinal()) {
            case 1: {
                return this.fogColor;
            }
            case 2: {
                return this.foliageColor;
            }
            case 3: {
                return this.waterColor;
            }
        }
        return this.grassColor;
    }

    @Override
    public int compareTo(BiomeColor that) {
        Ordering ordering = Ordering.natural().nullsLast();
        return ComparisonChain.start().compare((Object)this.biome, (Object)that.biome, (Comparator)ordering).compare((Object)this.grassColor, (Object)that.grassColor, (Comparator)ordering).compare((Object)this.fogColor, (Object)that.fogColor, (Comparator)ordering).compare((Object)this.foliageColor, (Object)that.foliageColor, (Comparator)ordering).compare((Object)this.waterColor, (Object)that.waterColor, (Comparator)ordering).result();
    }

    public static enum Effect {
        GRASS("jm.colorpalette.biome.grass"),
        FOG("jm.colorpalette.biome.fog"),
        FOLIAGE("jm.colorpalette.biome.foliage"),
        WATER("jm.colorpalette.biome.water");

        final String key;

        private Effect(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

