/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.import_export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import journeymap.client.data.WorldData;
import journeymap.client.io.FileHandler;
import journeymap.client.log.ChatLog;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.screens.AbstractPopupScreen;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.dialog.import_export.ImportExportPopup;
import journeymap.common.Journeymap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.network.chat.Component;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class ExportPopup
extends AbstractPopupScreen {
    private final File jmWorldDir;
    private final Map<File, Boolean> folderSelections = new HashMap<File, Boolean>();
    private final List<CheckBox> checkBoxes = new ArrayList<CheckBox>();
    private final Map<String, ImportExportPopup.DimensionFolder> dimensionFolders = new LinkedHashMap<String, ImportExportPopup.DimensionFolder>();

    public ExportPopup() {
        super((Component)Component.translatable((String)"jm.common.importexport_export_dialog"));
        this.jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
    }

    protected void init() {
        this.layout.spacing(6);
        this.layout.defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new StringWidget((Component)this.getTitle().copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), LayoutSettings::alignHorizontallyCenter);
        this.layout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.common.importexport_dialog_export_summary"), this.font), LayoutSettings::alignHorizontallyCenter);
        this.scanFolders(this.jmWorldDir);
        this.checkBoxes.clear();
        LinearLayout horizontalLayout = LinearLayout.horizontal();
        horizontalLayout.spacing(10);
        LinearLayout firstColumn = LinearLayout.vertical();
        firstColumn.spacing(2);
        for (File folder : this.folderSelections.keySet()) {
            if (!folder.getName().equals("waypoints")) continue;
            CheckBox waypointCheckBox = this.addCheckBox(folder);
            this.layout.addChild((LayoutElement)waypointCheckBox);
            this.layout.addChild((LayoutElement)new SpacerElement(0, 0));
            break;
        }
        this.layout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.dimensions").copy().withStyle(ChatFormatting.UNDERLINE), this.font), LayoutSettings::alignHorizontallyCenter);
        ArrayList<ImportExportPopup.DimensionFolder> dimFoldersList = new ArrayList<ImportExportPopup.DimensionFolder>(this.dimensionFolders.values());
        int totalDimensions = dimFoldersList.size();
        int dimensionsInCurrentColumn = 0;
        horizontalLayout.addChild((LayoutElement)firstColumn);
        LinearLayout currentVerticalLayout = firstColumn;
        for (int i = 0; i < totalDimensions; ++i) {
            ImportExportPopup.DimensionFolder dimFolder = (ImportExportPopup.DimensionFolder)dimFoldersList.get(i);
            if (dimensionsInCurrentColumn >= 7) {
                dimensionsInCurrentColumn = 0;
                currentVerticalLayout = LinearLayout.vertical();
                currentVerticalLayout.spacing(2);
                horizontalLayout.addChild((LayoutElement)currentVerticalLayout);
            }
            CheckBox dimCheckBox = this.addCheckBox(dimFolder.folder);
            currentVerticalLayout.addChild((LayoutElement)dimCheckBox);
            ++dimensionsInCurrentColumn;
        }
        this.layout.addChild((LayoutElement)horizontalLayout);
        LinearLayout buttonLayout = LinearLayout.horizontal();
        buttonLayout.spacing(10);
        buttonLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.importexport_export_button"), button -> this.exportSelectedFolders()).build());
        buttonLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.close"), button -> super.onClose()).build());
        this.layout.addChild((LayoutElement)buttonLayout);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        super.repositionElements();
    }

    private CheckBox addCheckBox(File folder) {
        String folderName = folder.getName();
        CheckBox checkBox = new CheckBox(folderName, true, button -> {
            boolean toggled = ((CheckBox)button).getToggled();
            this.folderSelections.put(folder, toggled);
        });
        this.checkBoxes.add(checkBox);
        return checkBox;
    }

    private void exportSelectedFolders() {
        String result;
        boolean anySelected = false;
        for (Boolean selected : this.folderSelections.values()) {
            if (!selected.booleanValue()) continue;
            anySelected = true;
            break;
        }
        if (!anySelected) {
            Journeymap.getLogger().warn("No folders selected for export");
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        String timestamp = dateFormat.format(new Date());
        String worldName = "unknown";
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            worldName = WorldData.getWorldName(mc).replaceAll("\\W+", "~");
        }
        String defaultFileName = "journeymap_export_" + worldName + "_" + timestamp + ".zip";
        File screenshotsDir = new File(FileHandler.getMinecraftDirectory(), "screenshots");
        if (!screenshotsDir.exists()) {
            screenshotsDir.mkdir();
        }
        String defaultPath = new File(screenshotsDir, defaultFileName).getAbsolutePath();
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filterPatterns = stack.mallocPointer(1);
            filterPatterns.put(stack.UTF8((CharSequence)"*.zip"));
            filterPatterns.flip();
            result = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Export JourneyMap Data", (CharSequence)defaultPath, (PointerBuffer)filterPatterns, (CharSequence)"ZIP Files");
        }
        if (result != null) {
            File fileToSave = !result.toLowerCase().endsWith(".zip") ? new File(result + ".zip") : new File(result);
            try {
                this.createZipFile(fileToSave);
                ChatLog.announceFile("JourneyMap data exported to " + String.valueOf(fileToSave), fileToSave);
                Journeymap.getLogger().info("JourneyMap data exported to " + fileToSave.getAbsolutePath());
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Error exporting JourneyMap data: " + e.getMessage(), (Throwable)e);
                ChatLog.announceError("Error exporting JourneyMap data: " + e.getMessage());
            }
        } else {
            Journeymap.getLogger().info("Export cancelled by user");
        }
        this.onClose();
    }

    private void createZipFile(File zipFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            File baseDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
            for (Map.Entry<File, Boolean> entry : this.folderSelections.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                File folder = entry.getKey();
                boolean isDimensionFolder = false;
                for (ImportExportPopup.DimensionFolder dimFolder : this.dimensionFolders.values()) {
                    if (!dimFolder.folder.equals(folder)) continue;
                    isDimensionFolder = true;
                    break;
                }
                this.addFolderToZip(zos, folder, baseDir, isDimensionFolder);
            }
        }
    }

    private void addFolderToZip(ZipOutputStream zos, File folder, File baseDir, boolean isDimensionFolder) throws IOException {
        File[] files;
        String folderRelativePath = this.getRelativePath(folder, baseDir);
        if (!folder.equals(baseDir)) {
            ZipEntry zipEntry = new ZipEntry(folderRelativePath + "/");
            zos.putNextEntry(zipEntry);
            zos.closeEntry();
        }
        if ((files = folder.listFiles()) != null) {
            for (File file : files) {
                int length;
                String relativePath = this.getRelativePath(file, baseDir);
                if (file.isDirectory()) {
                    boolean includeFolder;
                    boolean bl = includeFolder = isDimensionFolder || this.folderSelections.getOrDefault(file, false) != false || file.isDirectory() && file.getName().startsWith("cache");
                    if (!includeFolder) continue;
                    this.addFolderToZip(zos, file, baseDir, false);
                    continue;
                }
                ZipEntry zipEntry = new ZipEntry(relativePath);
                zos.putNextEntry(zipEntry);
                byte[] buffer = new byte[1024];
                FileInputStream fis = new FileInputStream(file);
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                fis.close();
                zos.closeEntry();
            }
        }
    }

    private String getRelativePath(File file, File baseDir) {
        String basePath = baseDir.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(basePath)) {
            return filePath.substring(basePath.length() + 1).replace('\\', '/');
        }
        File currentFile = file;
        StringBuilder relativePath = new StringBuilder(currentFile.getName());
        while ((currentFile = currentFile.getParentFile()) != null && !currentFile.equals(baseDir)) {
            relativePath.insert(0, currentFile.getName() + "/");
        }
        return relativePath.toString();
    }

    private void scanFolders(File jmWorldDir) {
        this.dimensionFolders.clear();
        this.folderSelections.clear();
        File[] files = jmWorldDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || file.listFiles().length <= 0) continue;
                String folderName = file.getName();
                if (folderName.equals("waypoints")) {
                    this.folderSelections.put(file, true);
                    continue;
                }
                ImportExportPopup.DimensionFolder dimFolder = new ImportExportPopup.DimensionFolder(folderName, file);
                this.dimensionFolders.put(folderName, dimFolder);
                this.folderSelections.put(file, true);
            }
        }
    }

    public void onClose() {
        this.popLayer();
        super.onClose();
    }
}

