/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.init.ModAttachmentTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class AttachmentUtils {
    public static final int[] LOAD_ALL = new int[]{1, 1, 1};
    public static final int[] NO_ITEMS = new int[]{0, 0, 0};
    public static final int[] UPGRADES_ONLY = new int[]{0, 1, 0};
    public static final int[] TOOLS_ONLY = new int[]{0, 0, 1};

    public static Optional<ITravelersBackpack> getAttachment(Player player) {
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of((ITravelersBackpack)player.getData(ModAttachmentTypes.TRAVELERS_BACKPACK.get()));
    }

    public static void synchronise(Player player) {
        AttachmentUtils.getAttachment(player).ifPresent(ITravelersBackpack::synchronise);
    }

    public static boolean isWearingBackpack(Player player) {
        if (TravelersBackpack.enableIntegration()) {
            if (TravelersBackpack.enableCurios() && CuriosApi.getCuriosInventory((LivingEntity)player).isPresent() && ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get()).isEquipped(t -> t.getItem() instanceof TravelersBackpackItem)) {
                return true;
            }
            return TravelersBackpack.enableAccessories() && AccessoriesCapability.getOptionally((LivingEntity)player).isPresent() && AccessoriesCapability.get((LivingEntity)player).isEquipped(t -> t.getItem() instanceof TravelersBackpackItem);
        }
        if (AttachmentUtils.getAttachment(player).isPresent()) {
            return AttachmentUtils.getAttachment(player).get().hasBackpack() && AttachmentUtils.getAttachment(player).get().getBackpack().getItem() instanceof TravelersBackpackItem;
        }
        return false;
    }

    public static ItemStack getWearingBackpack(Player player) {
        if (TravelersBackpack.enableIntegration()) {
            Optional curio;
            ICuriosItemHandler curios;
            if (TravelersBackpack.enableCurios() && CuriosApi.getCuriosInventory((LivingEntity)player).isPresent() && (curios = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get()).isEquipped(t -> t.getItem() instanceof TravelersBackpackItem) && (curio = curios.findFirstCurio(t -> t.getItem() instanceof TravelersBackpackItem)).isPresent()) {
                return ((SlotResult)curio.get()).stack();
            }
            if (TravelersBackpack.enableAccessories() && AccessoriesCapability.getOptionally((LivingEntity)player).isPresent() && AccessoriesCapability.get((LivingEntity)player).getFirstEquipped(t -> t.getItem() instanceof TravelersBackpackItem) != null) {
                return AccessoriesCapability.get((LivingEntity)player).getFirstEquipped(t -> t.getItem() instanceof TravelersBackpackItem).stack();
            }
            return ItemStack.EMPTY;
        }
        return AttachmentUtils.isWearingBackpack(player) ? AttachmentUtils.getAttachment(player).get().getBackpack() : ItemStack.EMPTY;
    }

    public static void equipBackpack(Player player, ItemStack stack) {
        if (AttachmentUtils.getAttachment(player).isPresent() && !AttachmentUtils.isWearingBackpack(player)) {
            AttachmentUtils.getAttachment(player).ifPresent(attachment -> attachment.equipBackpack(stack));
            player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, (1.0f + (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.2f) * 0.7f);
            AttachmentUtils.synchronise(player);
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player, ItemStack stack) {
        return AttachmentUtils.getBackpackWrapper(player, stack, LOAD_ALL);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player, ItemStack stack, int[] dataLoad) {
        if (TravelersBackpack.enableIntegration()) {
            if (AttachmentUtils.isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, stack, dataLoad);
            }
            return null;
        }
        if (AttachmentUtils.isWearingBackpack(player)) {
            return AttachmentUtils.getAttachment(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapperArtificial(Player player) {
        return AttachmentUtils.getBackpackWrapper(player, NO_ITEMS);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player) {
        return AttachmentUtils.getBackpackWrapper(player, LOAD_ALL);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player, int[] dataLoad) {
        if (TravelersBackpack.enableIntegration()) {
            if (AttachmentUtils.isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, AttachmentUtils.getWearingBackpack(player), dataLoad);
            }
            return null;
        }
        if (AttachmentUtils.isWearingBackpack(player)) {
            return AttachmentUtils.getAttachment(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }
}

