/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids.effects;

import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class PotionEffect
extends EffectFluid {
    public PotionEffect(String uniqueId, Fluid fluid) {
        super(uniqueId, fluid, 250);
    }

    public PotionEffect(String uniqueId, String modid, String fluidName) {
        super(uniqueId, modid, fluidName, 250);
    }

    @Override
    public void affectDrinker(FluidStack stack, Level level, Entity entity) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            for (MobEffectInstance mobEffectInstance : ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).getAllEffects()) {
                if (((MobEffect)mobEffectInstance.getEffect().value()).isInstantenous()) {
                    ((MobEffect)mobEffectInstance.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, (LivingEntity)player, mobEffectInstance.getAmplifier(), 1.0);
                    continue;
                }
                player.addEffect(new MobEffectInstance(mobEffectInstance));
            }
        }
    }

    @Override
    public boolean canExecuteEffect(FluidStack stack, Level level, Entity entity) {
        return stack.getAmount() >= this.amountRequired;
    }
}

