/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.client.model;

import bagu_chan.bagus_lib.client.layer.IArmor;
import baguchan.hunters_return.HunterConfig;
import baguchan.hunters_return.client.animation.HunterAnimations;
import baguchan.hunters_return.entity.Hunter;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HunterModel<T extends Hunter>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel,
IArmor {
    private final ModelPart body;
    private final ModelPart everything;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart root;
    public final ModelPart head;
    private final ModelPart cape;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;

    public HunterModel(ModelPart root) {
        this.root = root;
        this.everything = root.getChild("everything");
        this.body = this.everything.getChild("body");
        this.cape = this.body.getChild("cape");
        this.LeftLeg = this.everything.getChild("left_leg");
        this.RightLeg = this.everything.getChild("right_leg");
        this.RightArm = this.body.getChild("right_arm");
        this.LeftArm = this.body.getChild("left_arm");
        this.head = this.body.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition everything = partdefinition.addOrReplaceChild("everything", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_leg = everything.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(49, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = everything.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(44, 44).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = everything.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 13).addBox(-4.0f, -11.75f, -2.5f, 8.0f, 14.0f, 5.0f, new CubeDeformation(0.75f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition cape = body.addOrReplaceChild("cape", CubeListBuilder.create().texOffs(28, 32).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 15.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(65, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.15f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(6, 7).addBox(0.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(6, 7).addBox(-1.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition righteyebrows = head.addOrReplaceChild("righteyebrows", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition righteyebrows_r1 = righteyebrows.addOrReplaceChild("righteyebrows_r1", CubeListBuilder.create().texOffs(39, 0).addBox(-1.5f, -1.0f, -0.5902f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition lefteyebrows = head.addOrReplaceChild("lefteyebrows", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition lefteyebrows_r1 = lefteyebrows.addOrReplaceChild("lefteyebrows_r1", CubeListBuilder.create().texOffs(39, 0).mirror().addBox(-3.5f, -1.0f, -0.5902f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(16, 44).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_arm_r1 = left_arm.addOrReplaceChild("left_arm_r1", CubeListBuilder.create().texOffs(17, 18).addBox(5.0f, 2.25f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(48, 32).mirror().addBox(0.0f, -0.75f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition leftHand = left_arm.addOrReplaceChild("leftHand", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)9.5f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 36).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_arm_r1 = right_arm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(19, 0).addBox(-7.0f, 2.25f, -3.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 0).mirror().addBox(-5.0f, -0.75f, -3.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition rightHand = right_arm.addOrReplaceChild("rightHand", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AbstractIllager.IllagerArmPose abstractillager$illagerarmpose = ((Hunter)((Object)entityIn)).getArmPose();
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        if (this.riding) {
            this.RightArm.xRot = -0.62831855f;
            this.RightArm.yRot = 0.0f;
            this.RightArm.zRot = 0.0f;
            this.LeftArm.xRot = -0.62831855f;
            this.LeftArm.yRot = 0.0f;
            this.LeftArm.zRot = 0.0f;
            this.RightLeg.xRot = -1.4137167f;
            this.RightLeg.yRot = 0.31415927f;
            this.RightLeg.zRot = 0.07853982f;
            this.LeftLeg.xRot = -1.4137167f;
            this.LeftLeg.yRot = -0.31415927f;
            this.LeftLeg.zRot = -0.07853982f;
        } else if (!((Boolean)HunterConfig.CLIENT.oldAnimation.get()).booleanValue()) {
            if (((Hunter)((Object)entityIn)).chargeAnimationState.isStarted()) {
                if (entityIn.getMainArm() == HumanoidArm.RIGHT) {
                    this.animateWalk(HunterAnimations.HUNTER_RIGHT_WALK_ATTACK, limbSwing, limbSwingAmount, 1.0f, 1.5f);
                } else {
                    this.animateWalk(HunterAnimations.HUNTER_LEFT_WALK_ATTACK, limbSwing, limbSwingAmount, 1.0f, 1.5f);
                }
            } else if (!entityIn.isSleeping()) {
                this.animateWalk(HunterAnimations.HUNTER_WALK, limbSwing, limbSwingAmount, 1.0f, 1.5f);
            }
        } else {
            this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.RightArm.yRot = 0.0f;
            this.RightArm.zRot = 0.0f;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.LeftArm.yRot = 0.0f;
            this.LeftArm.zRot = 0.0f;
            this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.RightLeg.yRot = 0.0f;
            this.RightLeg.zRot = 0.0f;
            this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.LeftLeg.yRot = 0.0f;
            this.LeftLeg.zRot = 0.0f;
        }
        if (!((Boolean)HunterConfig.CLIENT.oldAnimation.get()).booleanValue()) {
            if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
                AnimationUtils.animateCrossbowHold((ModelPart)this.RightArm, (ModelPart)this.LeftArm, (ModelPart)this.head, (boolean)true);
            } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
                HunterModel.animateCrossbowCharge(this.RightArm, this.LeftArm, entityIn, true);
            } else if (entityIn.getMainArm() == HumanoidArm.RIGHT) {
                this.animate(((Hunter)((Object)entityIn)).shootAnimationState, HunterAnimations.HUNTER_RIGHT_SHOT, ageInTicks);
                this.animate(((Hunter)((Object)entityIn)).chargeAnimationState, HunterAnimations.HUNTER_RIGHT_ATTACK_RANGE_CHARGE, ageInTicks);
                this.animate(((Hunter)((Object)entityIn)).attackAnimationState, HunterAnimations.HUNTER_RIGHT_ATTACK_MELEE, ageInTicks, 1.5f);
                this.animate(((Hunter)((Object)entityIn)).thrownAnimationState, HunterAnimations.HUNTER_LEFT_ATTACK_MELEE, ageInTicks);
            } else {
                this.animate(((Hunter)((Object)entityIn)).shootAnimationState, HunterAnimations.HUNTER_LEFT_SHOT, ageInTicks);
                this.animate(((Hunter)((Object)entityIn)).chargeAnimationState, HunterAnimations.HUNTER_LEFT_ATTACK_RANGE_CHARGE, ageInTicks);
                this.animate(((Hunter)((Object)entityIn)).attackAnimationState, HunterAnimations.HUNTER_LEFT_ATTACK_MELEE, ageInTicks, 1.5f);
                this.animate(((Hunter)((Object)entityIn)).thrownAnimationState, HunterAnimations.HUNTER_RIGHT_ATTACK_MELEE, ageInTicks);
            }
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (entityIn.getMainHandItem().isEmpty()) {
                AnimationUtils.animateZombieArms((ModelPart)this.LeftArm, (ModelPart)this.RightArm, (boolean)true, (float)this.attackTime, (float)ageInTicks);
            } else {
                AnimationUtils.swingWeaponDown((ModelPart)this.RightArm, (ModelPart)this.LeftArm, entityIn, (float)this.attackTime, (float)ageInTicks);
            }
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.SPELLCASTING) {
            this.RightArm.z = 0.0f;
            this.RightArm.x = -5.0f;
            this.LeftArm.z = 0.0f;
            this.LeftArm.x = 5.0f;
            this.RightArm.xRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.LeftArm.xRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.RightArm.zRot = 2.3561945f;
            this.LeftArm.zRot = -2.3561945f;
            this.RightArm.yRot = 0.0f;
            this.LeftArm.yRot = 0.0f;
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.BOW_AND_ARROW) {
            this.RightArm.yRot = -0.1f + this.head.yRot;
            this.RightArm.xRot = -1.5707964f + this.head.xRot;
            this.LeftArm.xRot = -0.9424779f + this.head.xRot;
            this.LeftArm.yRot = this.head.yRot - 0.4f;
            this.LeftArm.zRot = 1.5707964f;
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.animateCrossbowHold((ModelPart)this.RightArm, (ModelPart)this.LeftArm, (ModelPart)this.head, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.animateCrossbowCharge((ModelPart)this.RightArm, (ModelPart)this.LeftArm, entityIn, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CELEBRATING) {
            this.RightArm.z = 0.0f;
            this.RightArm.x = -5.0f;
            this.RightArm.xRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.RightArm.zRot = 2.670354f;
            this.RightArm.yRot = 0.0f;
            this.LeftArm.z = 0.0f;
            this.LeftArm.x = 5.0f;
            this.LeftArm.xRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.LeftArm.zRot = -2.3561945f;
            this.LeftArm.yRot = 0.0f;
        }
    }

    public static void animateCrossbowCharge(ModelPart p_102087_, ModelPart p_102088_, LivingEntity p_102089_, boolean p_102090_) {
        ModelPart modelpart = p_102090_ ? p_102087_ : p_102088_;
        ModelPart modelpart1 = p_102090_ ? p_102088_ : p_102087_;
        modelpart.yRot = p_102090_ ? -0.8f : 0.8f;
        modelpart1.xRot = modelpart.xRot = -0.97079635f;
        float f = p_102089_.getUseItem().getUseDuration(p_102089_);
        float f1 = Mth.clamp((float)p_102089_.getTicksUsingItem(), (float)0.0f, (float)f);
        float f2 = f1 / f;
        modelpart1.yRot = Mth.lerp((float)f2, (float)0.4f, (float)0.85f) * (float)(p_102090_ ? 1 : -1);
        modelpart1.xRot = Mth.lerp((float)f2, (float)modelpart1.xRot, (float)-1.5707964f);
    }

    public void prepareMobModel(T entity, float p_103794_, float p_103795_, float p_103796_) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemstack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemstack.is(Items.GOAT_HORN) && entity.isUsingItem()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.TOOT_HORN;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.TOOT_HORN;
            }
        }
        super.prepareMobModel(entity, p_103794_, p_103795_, p_103796_);
    }

    private void poseRightArm(T p_102876_) {
        switch (this.rightArmPose) {
            case SPYGLASS: {
                this.RightArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (p_102876_.isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.RightArm.yRot = this.head.yRot - 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.RightArm.xRot = Mth.clamp((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.RightArm.yRot = this.head.yRot - 0.5235988f;
            }
        }
    }

    private void poseLeftArm(T p_102879_) {
        switch (this.leftArmPose) {
            case SPYGLASS: {
                this.LeftArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (p_102879_.isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.LeftArm.yRot = this.head.yRot + 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.LeftArm.xRot = Mth.clamp((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.LeftArm.yRot = this.head.yRot + 0.5235988f;
            }
        }
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHand(HumanoidArm p_102925_, PoseStack p_102926_) {
        this.everything.translateAndRotate(p_102926_);
        this.body.translateAndRotate(p_102926_);
        this.getArm(p_102925_).translateAndRotate(p_102926_);
    }

    public void copyPropertiesTo(HunterModel<T> p_102873_) {
        super.copyPropertiesTo(p_102873_);
        p_102873_.leftArmPose = this.leftArmPose;
        p_102873_.rightArmPose = this.rightArmPose;
    }

    public ModelPart root() {
        return this.root;
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.1f, 0.0f);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.75f, 0.0f);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.RightArm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.LeftArm);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.RightLeg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.LeftLeg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

