/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.data;

import com.supermartijn642.connectedglass.CGColoredGlassBlock;
import com.supermartijn642.connectedglass.CGColoredPaneBlock;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.core.generator.RecipeGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CGRecipeGenerator
extends RecipeGenerator {
    private Block vanillaBlock;
    private final List<Block> vanillaBlocks = new ArrayList<Block>();
    private final EnumMap<DyeColor, Block> vanillaColoredBlocks = new EnumMap(DyeColor.class);
    private Block vanillaPane;
    private final List<Block> vanillaPanes = new ArrayList<Block>();
    private final EnumMap<DyeColor, Block> vanillaColoredPanes = new EnumMap(DyeColor.class);

    public CGRecipeGenerator(ResourceCache cache) {
        super("connectedglass", cache);
    }

    public void generate() {
        Object previous;
        this.gatherVanillaBlocks();
        this.gatherVanillaPanes();
        CGGlassType lastType = null;
        CGGlassType lastTypeTinted = null;
        for (CGGlassType type : CGGlassType.values()) {
            DyeColor color;
            for (CGGlassBlock cGGlassBlock : type.blocks) {
                DyeColor dyeColor = color = cGGlassBlock instanceof CGColoredGlassBlock ? ((CGColoredGlassBlock)cGGlassBlock).getColor() : null;
                Object previous2 = type.isTinted ? (lastTypeTinted == null ? (color == null ? Blocks.TINTED_GLASS : null) : lastTypeTinted.getBlock(color)) : (lastType == null ? this.getVanillaBlock(color) : lastType.getBlock(color));
                if (previous2 == null) continue;
                this.shaped(Registries.BLOCKS.getIdentifier((Object)cGGlassBlock).getPath() + "1", (ItemLike)cGGlassBlock, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous2}).unlockedBy(new ItemLike[]{previous2});
            }
            for (CGColoredGlassBlock cGColoredGlassBlock : type.colored_blocks.values()) {
                ((RecipeGenerator.ShapedRecipeBuilder)this.shaped(Registries.BLOCKS.getIdentifier((Object)cGColoredGlassBlock).getPath() + "2", (ItemLike)cGColoredGlassBlock, 8).pattern("AAA").pattern("ABA").pattern("AAA").input('A', new ItemLike[]{type.block}).input('B', cGColoredGlassBlock.getColor().getTag()).unlockedBy(new ItemLike[]{type.block})).unlockedBy(cGColoredGlassBlock.getColor().getTag());
            }
            if (type.hasPanes) {
                for (CGPaneBlock cGPaneBlock : type.panes) {
                    DyeColor dyeColor = color = cGPaneBlock instanceof CGColoredPaneBlock ? ((CGColoredPaneBlock)cGPaneBlock).getColor() : null;
                    Object previous2 = type.isTinted ? (lastTypeTinted == null ? null : lastTypeTinted.getPane(color)) : (lastType == null ? this.getVanillaPane(color) : lastType.getPane(color));
                    if (previous2 == null) continue;
                    this.shaped(Registries.BLOCKS.getIdentifier((Object)cGPaneBlock).getPath() + "1", (ItemLike)cGPaneBlock, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous2}).unlockedBy(new ItemLike[]{previous2});
                }
                for (CGColoredPaneBlock cGColoredPaneBlock : type.colored_panes.values()) {
                    ((RecipeGenerator.ShapedRecipeBuilder)this.shaped(Registries.BLOCKS.getIdentifier((Object)cGColoredPaneBlock).getPath() + "2", (ItemLike)cGColoredPaneBlock, 8).pattern("AAA").pattern("ABA").pattern("AAA").input('A', new ItemLike[]{type.pane}).input('B', cGColoredPaneBlock.getColor().getTag()).unlockedBy(new ItemLike[]{type.pane})).unlockedBy(cGColoredPaneBlock.getColor().getTag());
                }
                for (CGGlassBlock cGGlassBlock : type.blocks) {
                    color = cGGlassBlock instanceof CGColoredGlassBlock ? ((CGColoredGlassBlock)cGGlassBlock).getColor() : null;
                    CGPaneBlock pane = type.getPane(color);
                    this.shaped(Registries.BLOCKS.getIdentifier((Object)pane).getPath() + "3", (ItemLike)pane, 16).pattern("AAA").pattern("AAA").input('A', new ItemLike[]{cGGlassBlock}).unlockedBy(new ItemLike[]{cGGlassBlock});
                }
            }
            if (type.isTinted) {
                lastTypeTinted = type;
                continue;
            }
            lastType = type;
        }
        for (Block block : this.vanillaBlocks) {
            DyeColor color = block instanceof BeaconBeamBlock ? ((BeaconBeamBlock)block).getColor() : null;
            previous = lastType.getBlock(color);
            this.shaped("vanilla_" + Registries.BLOCKS.getIdentifier((Object)block).getPath(), (ItemLike)block, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous}).unlockedBy(new ItemLike[]{previous});
        }
        for (Block pane : this.vanillaPanes) {
            DyeColor color = pane instanceof BeaconBeamBlock ? ((BeaconBeamBlock)pane).getColor() : null;
            previous = lastType.getPane(color);
            this.shaped("vanilla_" + Registries.BLOCKS.getIdentifier((Object)pane).getPath(), (ItemLike)pane, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous}).unlockedBy(new ItemLike[]{previous});
        }
        CGGlassBlock previous3 = lastTypeTinted.getBlock(null);
        this.shaped("vanilla_" + Registries.BLOCKS.getIdentifier((Object)Blocks.TINTED_GLASS).getPath(), (ItemLike)Blocks.TINTED_GLASS, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous3}).unlockedBy(new ItemLike[]{previous3});
    }

    private void gatherVanillaBlocks() {
        this.addVanillaBlock(Blocks.GLASS);
        this.addVanillaBlock(Blocks.WHITE_STAINED_GLASS);
        this.addVanillaBlock(Blocks.ORANGE_STAINED_GLASS);
        this.addVanillaBlock(Blocks.MAGENTA_STAINED_GLASS);
        this.addVanillaBlock(Blocks.LIGHT_BLUE_STAINED_GLASS);
        this.addVanillaBlock(Blocks.YELLOW_STAINED_GLASS);
        this.addVanillaBlock(Blocks.LIME_STAINED_GLASS);
        this.addVanillaBlock(Blocks.PINK_STAINED_GLASS);
        this.addVanillaBlock(Blocks.GRAY_STAINED_GLASS);
        this.addVanillaBlock(Blocks.LIGHT_GRAY_STAINED_GLASS);
        this.addVanillaBlock(Blocks.CYAN_STAINED_GLASS);
        this.addVanillaBlock(Blocks.PURPLE_STAINED_GLASS);
        this.addVanillaBlock(Blocks.BLUE_STAINED_GLASS);
        this.addVanillaBlock(Blocks.BROWN_STAINED_GLASS);
        this.addVanillaBlock(Blocks.GREEN_STAINED_GLASS);
        this.addVanillaBlock(Blocks.RED_STAINED_GLASS);
        this.addVanillaBlock(Blocks.BLACK_STAINED_GLASS);
    }

    private void addVanillaBlock(Block block) {
        DyeColor color;
        this.vanillaBlocks.add(block);
        DyeColor dyeColor = color = block instanceof BeaconBeamBlock ? ((BeaconBeamBlock)block).getColor() : null;
        if (color == null) {
            this.vanillaBlock = block;
        } else {
            this.vanillaColoredBlocks.put(color, block);
        }
    }

    private void gatherVanillaPanes() {
        this.addVanillaPane(Blocks.GLASS_PANE);
        this.addVanillaPane(Blocks.WHITE_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.ORANGE_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.MAGENTA_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.LIGHT_BLUE_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.YELLOW_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.LIME_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.PINK_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.GRAY_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.LIGHT_GRAY_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.CYAN_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.PURPLE_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.BLUE_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.BROWN_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.GREEN_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.RED_STAINED_GLASS_PANE);
        this.addVanillaPane(Blocks.BLACK_STAINED_GLASS_PANE);
    }

    private void addVanillaPane(Block pane) {
        DyeColor color;
        this.vanillaPanes.add(pane);
        DyeColor dyeColor = color = pane instanceof BeaconBeamBlock ? ((BeaconBeamBlock)pane).getColor() : null;
        if (color == null) {
            this.vanillaPane = pane;
        } else {
            this.vanillaColoredPanes.put(color, pane);
        }
    }

    private Block getVanillaBlock(DyeColor color) {
        if (color == null) {
            return this.vanillaBlock;
        }
        return this.vanillaColoredBlocks.get(color);
    }

    private Block getVanillaPane(DyeColor color) {
        if (color == null) {
            return this.vanillaPane;
        }
        return this.vanillaColoredPanes.get(color);
    }
}

