/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.exclusive_weapons.registry.item;

import com.cerbon.exclusive_weapons.registry.RegistryEntry;
import com.cerbon.exclusive_weapons.registry.ResourcefulRegistries;
import com.cerbon.exclusive_weapons.registry.ResourcefulRegistry;
import com.cerbon.exclusive_weapons.registry.item.ToolType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;

public class ItemRegistry {
    private final ResourcefulRegistry<Item> itemRegistry;

    public ItemRegistry(String modId) {
        this.itemRegistry = ResourcefulRegistries.create(BuiltInRegistries.ITEM, modId);
    }

    public Map<ArmorItem.Type, RegistryEntry<ArmorItem>> registerFullArmorSet(Supplier<Holder<ArmorMaterial>> material, int durabilityFactor, String materialName) {
        return this.registerFullArmorSet(material, List.of(Integer.valueOf(durabilityFactor), Integer.valueOf(durabilityFactor), Integer.valueOf(durabilityFactor), Integer.valueOf(durabilityFactor)), materialName);
    }

    public Map<ArmorItem.Type, RegistryEntry<ArmorItem>> registerFullArmorSet(Supplier<Holder<ArmorMaterial>> material, List<Integer> durabilityFactors, String materialName) {
        return this.registerFullArmorSet(material, properties -> properties, durabilityFactors, materialName);
    }

    public Map<ArmorItem.Type, RegistryEntry<ArmorItem>> registerFullArmorSet(Supplier<Holder<ArmorMaterial>> material, UnaryOperator<Item.Properties> itemProperties, List<Integer> durabilityFactors, String materialName) {
        Preconditions.checkArgument((durabilityFactors != null && durabilityFactors.size() == 4 ? 1 : 0) != 0, (Object)"Expected durability array of length 4 (helmet, chest, legs, boots)");
        return ImmutableMap.of((Object)ArmorItem.Type.HELMET, this.registerArmor(ArmorItem.Type.HELMET, material, itemProperties, durabilityFactors.get(0), materialName), (Object)ArmorItem.Type.CHESTPLATE, this.registerArmor(ArmorItem.Type.CHESTPLATE, material, itemProperties, durabilityFactors.get(1), materialName), (Object)ArmorItem.Type.LEGGINGS, this.registerArmor(ArmorItem.Type.LEGGINGS, material, itemProperties, durabilityFactors.get(2), materialName), (Object)ArmorItem.Type.BOOTS, this.registerArmor(ArmorItem.Type.BOOTS, material, itemProperties, durabilityFactors.get(3), materialName));
    }

    public RegistryEntry<ArmorItem> registerArmor(ArmorItem.Type armorType, Supplier<Holder<ArmorMaterial>> material, int durabilityFactor, String materialName) {
        return this.registerArmor(armorType, material, properties -> properties, durabilityFactor, materialName);
    }

    public RegistryEntry<ArmorItem> registerArmor(ArmorItem.Type armorType, Supplier<Holder<ArmorMaterial>> material, UnaryOperator<Item.Properties> itemProperties, int durabilityFactor, String materialName) {
        return this.registerItem(() -> new ArmorItem((Holder)material.get(), armorType, (Item.Properties)itemProperties.apply(new Item.Properties().durability(armorType.getDurability(durabilityFactor)))), materialName + "_" + armorType.getSerializedName());
    }

    public RegistryEntry<TieredItem> registerSimpleTool(ToolType toolType, Tier tier, float attackDamage, float attackSpeed, String id) {
        return this.registerSimpleTool(toolType, tier, properties -> properties, attackDamage, attackSpeed, id);
    }

    public RegistryEntry<TieredItem> registerSimpleTool(ToolType toolType, Tier tier, UnaryOperator<Item.Properties> itemProperties, float attackDamage, float attackSpeed, String id) {
        return switch (toolType) {
            default -> throw new MatchException(null, null);
            case ToolType.SWORD -> this.registerItem(() -> new SwordItem(tier, (Item.Properties)itemProperties.apply(new Item.Properties().attributes(SwordItem.createAttributes((Tier)tier, (int)((int)attackDamage), (float)attackSpeed)))), id);
            case ToolType.PICKAXE -> this.registerItem(() -> new PickaxeItem(tier, (Item.Properties)itemProperties.apply(new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)))), id);
            case ToolType.AXE -> this.registerItem(() -> new AxeItem(tier, (Item.Properties)itemProperties.apply(new Item.Properties().attributes(AxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)))), id);
            case ToolType.SHOVEL -> this.registerItem(() -> new ShovelItem(tier, (Item.Properties)itemProperties.apply(new Item.Properties().attributes(ShovelItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)))), id);
            case ToolType.HOE -> this.registerItem(() -> new HoeItem(tier, (Item.Properties)itemProperties.apply(new Item.Properties().attributes(HoeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)))), id);
        };
    }

    public RegistryEntry<Item> registerFood(FoodProperties foodProperties, String id) {
        return this.registerFood(foodProperties, properties -> properties, id);
    }

    public RegistryEntry<Item> registerFood(FoodProperties foodProperties, UnaryOperator<Item.Properties> itemProperties, String id) {
        return this.registerItem((Item.Properties)itemProperties.apply(new Item.Properties().food(foodProperties)), id);
    }

    public RegistryEntry<BlockItem> registerBlockItem(Supplier<Block> block, String id) {
        return this.registerBlockItem(block, new Item.Properties(), id);
    }

    public RegistryEntry<BlockItem> registerBlockItem(Supplier<Block> block, Item.Properties itemProperties, String id) {
        return this.registerBlockItem(id, () -> new BlockItem((Block)block.get(), itemProperties));
    }

    public RegistryEntry<BlockItem> registerBlockItem(String id, Supplier<BlockItem> blockItem) {
        return this.registerItem(blockItem, id);
    }

    public RegistryEntry<Item> registerItem(String id) {
        return this.registerItem(new Item.Properties(), id);
    }

    public RegistryEntry<Item> registerItem(Item.Properties itemProperties, String id) {
        return this.registerItem(() -> new Item(itemProperties), id);
    }

    public <T extends Item> RegistryEntry<T> registerItem(Supplier<T> item, String id) {
        return this.itemRegistry.register(id, item);
    }

    public Collection<RegistryEntry<Item>> getEntries() {
        return this.itemRegistry.getEntries();
    }

    public Stream<RegistryEntry<Item>> stream() {
        return this.itemRegistry.stream();
    }

    public Stream<Item> boundStream() {
        return this.itemRegistry.boundStream();
    }

    public void register() {
        this.itemRegistry.register();
    }
}

