/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.fastpaintings;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.fastpaintings.PaintingBlock;
import net.mehvahdjukaar.fastpaintings.PaintingBlockEntity;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PaintingBlockModel
implements CustomBakedModel {
    public static final ResourceLocation BACK_TEXTURE = ResourceLocation.withDefaultNamespace((String)"painting/back");
    private final BakedModel[] models = new BakedModel[16];

    public PaintingBlockModel(Map<String, BakedModel> paintingModels) {
        for (Map.Entry<String, BakedModel> e : paintingModels.entrySet()) {
            String k = e.getKey();
            int i = this.getIndex(k.contains("top"), k.contains("bottom"), k.contains("left"), k.contains("right"));
            this.models[i] = e.getValue();
        }
    }

    public int getIndex(boolean top, boolean bottom, boolean left, boolean right) {
        int index = 0;
        index |= (top ? 1 : 0) << 3;
        index |= (bottom ? 1 : 0) << 2;
        index |= (left ? 1 : 0) << 1;
        return index |= right ? 1 : 0;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        PaintingVariant variant = (PaintingVariant)data.get(PaintingBlockEntity.MIMIC_KEY);
        if (variant == null) {
            return List.of();
        }
        PaintingTextureManager paintingTextureManager = Minecraft.getInstance().getPaintingTextures();
        ResourceLocation paintingTexture = paintingTextureManager.get(variant).contents().name();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(ResourceLocation.fromNamespaceAndPath((String)paintingTexture.getNamespace(), (String)("painting/" + paintingTexture.getPath())));
        int paintingW = variant.width();
        int paintingH = variant.height();
        float segmentWScale = (float)sprite.contents().width() / (float)(paintingW * 16);
        float segmentHScale = (float)sprite.contents().height() / (float)(paintingH * 16);
        int rightOffset = (Integer)state.getValue((Property)PaintingBlock.RIGHT_OFFSET);
        int downOffset = (Integer)state.getValue((Property)PaintingBlock.DOWN_OFFSET);
        float spriteRightOff = (float)rightOffset * (sprite.getU1() - sprite.getU0()) / (float)paintingW;
        float spriteDownOff = (float)downOffset * (sprite.getV1() - sprite.getV0()) / (float)paintingH;
        ArrayList<BakedQuad> combinedQuads = new ArrayList<BakedQuad>();
        ArrayList<BakedModel> bakedModels = new ArrayList<BakedModel>();
        bakedModels.add(this.models[0]);
        int index = this.getIndex(downOffset == 0, downOffset == paintingH - 1, rightOffset == 0, rightOffset == paintingW - 1);
        bakedModels.add(this.models[index]);
        for (BakedModel model : bakedModels) {
            if (model == null) continue;
            List quads = model.getQuads(null, side, rand);
            for (BakedQuad q : quads) {
                TextureAtlasSprite oldSprite = q.getSprite();
                if (oldSprite.contents().name().equals((Object)MissingTextureAtlasSprite.getLocation())) {
                    int stride = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
                    stride = 8;
                    int[] v = Arrays.copyOf(q.getVertices(), q.getVertices().length);
                    for (int i = 0; i < v.length / stride; ++i) {
                        float originalU = Float.intBitsToFloat(v[i * stride + 4]);
                        float originalV = Float.intBitsToFloat(v[i * stride + 5]);
                        float u1 = (originalU - oldSprite.getU0()) * segmentWScale + spriteRightOff;
                        v[i * stride + 4] = Float.floatToRawIntBits(u1 + sprite.getU0());
                        float v1 = (originalV - oldSprite.getV0()) * segmentHScale + spriteDownOff;
                        v[i * stride + 5] = Float.floatToRawIntBits(v1 + sprite.getV0());
                    }
                    combinedQuads.add(new BakedQuad(v, q.getTintIndex(), q.getDirection(), sprite, q.isShade()));
                    continue;
                }
                combinedQuads.add(q);
            }
        }
        return combinedQuads;
    }

    public ExtraModelData getModelData(@Nullable ExtraModelData originalTileData, BlockPos pos, BlockState state, BlockAndTintGetter level) {
        PaintingBlockEntity tile;
        if (state.getBlock() instanceof PaintingBlock && !PaintingBlock.isMaster(state) && (tile = PaintingBlock.getMaster(state, pos, level)) != null) {
            return tile.getExtraModelData();
        }
        return originalTileData;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.models[0].getParticleIcon();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

