/*
 * Decompiled with CFR 0.152.
 */
package cydev.id.cyannouncer.bukkit;

import cydev.id.cyannouncer.bukkit.CyAnnouncer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;

public class AnnouncerCommand
implements CommandExecutor,
TabCompleter {
    private final CyAnnouncer plugin;

    public AnnouncerCommand(CyAnnouncer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "broadcast": {
                return this.handleBroadcast(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("announcer.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        this.plugin.loadConfig();
        this.plugin.startAnnouncements();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "CyAnnouncer configuration has been reloaded.");
        return true;
    }

    private boolean handleBroadcast(CommandSender sender, String[] args) {
        if (!sender.hasPermission("announcer.broadcast")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /announcer broadcast <world1,world2,...|all> <message>");
            return true;
        }
        String targets = args[0];
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.plugin.getPrefix() + String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length))));
        if (targets.equalsIgnoreCase("all")) {
            Bukkit.broadcastMessage((String)message);
        } else {
            List<String> targetWorlds = Arrays.asList(targets.split(","));
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!targetWorlds.contains(player.getWorld().getName())) continue;
                player.sendMessage(message);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- CyAnnouncer Help ---");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/announcer reload" + String.valueOf(ChatColor.WHITE) + " - Reloads the config file.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/announcer broadcast <worlds|all> <msg>" + String.valueOf(ChatColor.WHITE) + " - Broadcasts a message.");
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>(Arrays.asList("reload", "broadcast"));
            return subCommands.stream().filter(s2 -> s2.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("broadcast")) {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add("all");
            suggestions.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList()));
            return suggestions.stream().filter(s2 -> s2.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

