/*
 * Decompiled with CFR 0.152.
 */
package cydev.id.cyannouncer.bukkit;

import cydev.id.cyannouncer.bukkit.Announcement;
import cydev.id.cyannouncer.bukkit.AnnouncerCommand;
import cydev.id.cyannouncer.bukkit.lib.configurate.CommentedConfigurationNode;
import cydev.id.cyannouncer.bukkit.lib.configurate.yaml.YamlConfigurationLoader;
import cydev.id.cyannouncer.bukkit.libs.bstats.bukkit.Metrics;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class CyAnnouncer
extends JavaPlugin {
    private BukkitTask announcementTask;
    private List<Announcement> allMessages;
    private Map<String, List<Announcement>> worldSpecificMessages;
    private final Map<String, AtomicInteger> specificCounters = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, AtomicInteger> allCounters = new ConcurrentHashMap<String, AtomicInteger>();
    private String prefix;
    private int interval;
    private boolean placeholderApiEnabled = false;

    public void onEnable() {
        int pluginId = 27594;
        new Metrics(this, pluginId);
        this.loadConfig();
        AnnouncerCommand announcerExecutor = new AnnouncerCommand(this);
        this.getCommand("announcer").setExecutor((CommandExecutor)announcerExecutor);
        this.getCommand("announcer").setTabCompleter((TabCompleter)announcerExecutor);
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderApiEnabled = true;
            this.getLogger().info("Successfully hooked into PlaceholderAPI.");
        } else {
            this.getLogger().info("PlaceholderAPI not found. Placeholders will not be parsed.");
        }
        this.getLogger().info("CyAnnouncer has been enabled.");
        this.startAnnouncements();
    }

    public void loadConfig() {
        this.saveDefaultConfig();
        File configFile = new File(this.getDataFolder(), "config.yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(configFile)).build();
        try {
            CommentedConfigurationNode config = (CommentedConfigurationNode)loader.load();
            this.interval = ((CommentedConfigurationNode)config.node(new Object[]{"interval"})).getInt(60);
            this.prefix = ((CommentedConfigurationNode)config.node(new Object[]{"prefix"})).getString("&e[&l!&r&e] &r");
            this.allMessages = new ArrayList<Announcement>();
            this.worldSpecificMessages = new HashMap<String, List<Announcement>>();
            List announcementNodes = ((CommentedConfigurationNode)config.node(new Object[]{"announcements"})).childrenList();
            for (CommentedConfigurationNode node : announcementNodes) {
                List<String> worlds = ((CommentedConfigurationNode)node.node(new Object[]{"worlds"})).getList(String.class, Collections.emptyList());
                List<String> lines = ((CommentedConfigurationNode)node.node(new Object[]{"lines"})).getList(String.class, Collections.emptyList());
                if (worlds.isEmpty() || lines.isEmpty()) continue;
                Announcement announcement = new Announcement(worlds, lines);
                if (worlds.contains("all")) {
                    this.allMessages.add(announcement);
                    continue;
                }
                for (String worldName : worlds) {
                    this.worldSpecificMessages.computeIfAbsent(worldName, k -> new ArrayList()).add(announcement);
                }
            }
            this.getLogger().info("Configuration loaded. Found " + this.allMessages.size() + " global announcements and messages for " + this.worldSpecificMessages.size() + " specific worlds.");
            this.specificCounters.clear();
            this.allCounters.clear();
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load the configuration!");
            e.printStackTrace();
        }
    }

    public void startAnnouncements() {
        if (this.announcementTask != null) {
            this.announcementTask.cancel();
        }
        if (this.allMessages.isEmpty() && this.worldSpecificMessages.isEmpty() || this.interval <= 0) {
            this.getLogger().warning("Announcements are disabled (no messages found or invalid interval).");
            return;
        }
        this.announcementTask = this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
            if (this.getServer().getOnlinePlayers().isEmpty()) {
                return;
            }
            Map<String, List<Player>> playersByWorld = this.getServer().getOnlinePlayers().stream().collect(Collectors.groupingBy(player -> player.getWorld().getName()));
            for (String worldName : playersByWorld.keySet()) {
                List specificMessages = this.worldSpecificMessages.getOrDefault(worldName, Collections.emptyList());
                AtomicInteger specificCounter = this.specificCounters.computeIfAbsent(worldName, k -> new AtomicInteger(0));
                AtomicInteger allCounter = this.allCounters.computeIfAbsent(worldName, k -> new AtomicInteger(0));
                Announcement announcementToSend = null;
                if (!specificMessages.isEmpty() && specificCounter.get() < specificMessages.size()) {
                    announcementToSend = (Announcement)specificMessages.get(specificCounter.getAndIncrement());
                } else {
                    if (!this.allMessages.isEmpty()) {
                        announcementToSend = this.allMessages.get(allCounter.getAndIncrement());
                        if (allCounter.get() >= this.allMessages.size()) {
                            allCounter.set(0);
                        }
                    }
                    specificCounter.set(0);
                }
                if (announcementToSend == null) continue;
                List<Player> targetPlayers = playersByWorld.get(worldName);
                for (Player player2 : targetPlayers) {
                    for (String line : announcementToSend.lines()) {
                        String rawLine = this.prefix + line;
                        String parsedLine = this.placeholderApiEnabled ? PlaceholderAPI.setPlaceholders((Player)player2, (String)rawLine) : rawLine;
                        String finalLine = ChatColor.translateAlternateColorCodes((char)'&', (String)parsedLine);
                        player2.sendMessage(finalLine);
                    }
                }
            }
        }, 20L * (long)this.interval, 20L * (long)this.interval);
        this.getLogger().info("Announcements scheduler started, running every " + this.interval + " seconds.");
    }

    public String getPrefix() {
        return this.prefix;
    }
}

