/*
 * Decompiled with CFR 0.152.
 */
package cydev.id.cyannouncer.bukkit;

import cydev.id.cyannouncer.bukkit.Announcement;
import cydev.id.cyannouncer.bukkit.AnnouncerCommand;
import cydev.id.cyannouncer.bukkit.lib.configurate.CommentedConfigurationNode;
import cydev.id.cyannouncer.bukkit.lib.configurate.yaml.YamlConfigurationLoader;
import cydev.id.cyannouncer.bukkit.libs.bstats.bukkit.Metrics;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class CyAnnouncer
extends JavaPlugin {
    private BukkitTask announcementTask;
    private List<Announcement> allMessages;
    private Map<String, List<Announcement>> worldSpecificMessages;
    private final Map<String, AtomicInteger> specificCounters = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, AtomicInteger> allCounters = new ConcurrentHashMap<String, AtomicInteger>();
    private String prefix;
    private int interval;
    private boolean placeholderApiEnabled = false;
    private boolean isRandom = false;

    public void onEnable() {
        int pluginId = 27594;
        new Metrics(this, pluginId);
        this.loadConfig();
        AnnouncerCommand announcerExecutor = new AnnouncerCommand(this);
        this.getCommand("announcer").setExecutor((CommandExecutor)announcerExecutor);
        this.getCommand("announcer").setTabCompleter((TabCompleter)announcerExecutor);
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderApiEnabled = true;
            this.getLogger().info("Successfully hooked into PlaceholderAPI.");
        } else {
            this.getLogger().info("PlaceholderAPI not found. Placeholders will not be parsed.");
        }
        this.getLogger().info("CyAnnouncer has been enabled.");
        this.startAnnouncements();
    }

    public void loadConfig() {
        int targetConfigVersion = 2;
        File configFile = new File(this.getDataFolder(), "config.yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(configFile)).build();
        if (!configFile.exists()) {
            this.getLogger().info("No config.yml found, creating a new one...");
            this.saveDefaultConfig();
        }
        try {
            CommentedConfigurationNode config = (CommentedConfigurationNode)loader.load();
            int currentVersion = ((CommentedConfigurationNode)config.node(new Object[]{"config-version"})).getInt(0);
            if (currentVersion < targetConfigVersion) {
                this.getLogger().warning("!!! DETECTED OUTDATED CONFIG (Version " + currentVersion + ") !!!");
                this.getLogger().warning("Backing up your old config to 'config.yml.old'...");
                File oldConfigFile = new File(this.getDataFolder(), "config.yml.old");
                if (oldConfigFile.exists()) {
                    oldConfigFile.delete();
                }
                loader = null;
                if (!configFile.renameTo(oldConfigFile)) {
                    this.getLogger().severe("!!! FAILED TO BACK UP OLD CONFIG. Please do it manually! Aborting load.");
                    return;
                }
                this.getLogger().info("Successfully backed up old config.");
                this.saveDefaultConfig();
                loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(configFile)).build();
                config = (CommentedConfigurationNode)loader.load();
                this.getLogger().info("Successfully loaded new config.yml (Version " + targetConfigVersion + ").");
                this.getLogger().info("Please transfer your old announcement lines from 'config.yml.old'.");
            }
            this.interval = ((CommentedConfigurationNode)config.node(new Object[]{"interval"})).getInt(60);
            this.prefix = ((CommentedConfigurationNode)config.node(new Object[]{"prefix"})).getString("&e[&l!&r&e] &r");
            this.isRandom = ((CommentedConfigurationNode)config.node(new Object[]{"settings", "random"})).getBoolean(false);
            this.allMessages = new ArrayList<Announcement>();
            this.worldSpecificMessages = new HashMap<String, List<Announcement>>();
            List announcementNodes = ((CommentedConfigurationNode)config.node(new Object[]{"announcements"})).childrenList();
            for (CommentedConfigurationNode node : announcementNodes) {
                List<String> worlds = ((CommentedConfigurationNode)node.node(new Object[]{"worlds"})).getList(String.class, Collections.emptyList());
                List<String> lines = ((CommentedConfigurationNode)node.node(new Object[]{"lines"})).getList(String.class, Collections.emptyList());
                String type = ((CommentedConfigurationNode)node.node(new Object[]{"type"})).getString("CHAT").toUpperCase();
                String sound = ((CommentedConfigurationNode)node.node(new Object[]{"sound"})).getString("");
                if (worlds.isEmpty() || lines.isEmpty()) continue;
                Announcement announcement = new Announcement(worlds, lines, type, sound);
                if (worlds.contains("all")) {
                    this.allMessages.add(announcement);
                    continue;
                }
                for (String worldName : worlds) {
                    this.worldSpecificMessages.computeIfAbsent(worldName, k -> new ArrayList()).add(announcement);
                }
            }
            this.getLogger().info("Configuration loaded. Random Mode: " + this.isRandom);
            this.getLogger().info("Found " + this.allMessages.size() + " global announcements and messages for " + this.worldSpecificMessages.size() + " specific worlds.");
            this.specificCounters.clear();
            this.allCounters.clear();
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load the configuration!");
            e.printStackTrace();
        }
    }

    public void startAnnouncements() {
        if (this.announcementTask != null) {
            this.announcementTask.cancel();
        }
        if (this.allMessages.isEmpty() && this.worldSpecificMessages.isEmpty() || this.interval <= 0) {
            this.getLogger().warning("Announcements are disabled (no messages found or invalid interval).");
            return;
        }
        this.announcementTask = this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
            if (this.getServer().getOnlinePlayers().isEmpty()) {
                return;
            }
            Map<String, List<Player>> playersByWorld = this.getServer().getOnlinePlayers().stream().collect(Collectors.groupingBy(player -> player.getWorld().getName()));
            for (String worldName : playersByWorld.keySet()) {
                List specificMessages = this.worldSpecificMessages.getOrDefault(worldName, Collections.emptyList());
                List<Player> targetPlayers = playersByWorld.get(worldName);
                Announcement announcementToSend = null;
                if (this.isRandom) {
                    ArrayList<Announcement> availableMessages = new ArrayList<Announcement>(this.allMessages);
                    availableMessages.addAll(specificMessages);
                    if (!availableMessages.isEmpty()) {
                        announcementToSend = (Announcement)availableMessages.get(new Random().nextInt(availableMessages.size()));
                    }
                } else {
                    AtomicInteger specificCounter = this.specificCounters.computeIfAbsent(worldName, k -> new AtomicInteger(0));
                    AtomicInteger allCounter = this.allCounters.computeIfAbsent(worldName, k -> new AtomicInteger(0));
                    if (!specificMessages.isEmpty() && specificCounter.get() < specificMessages.size()) {
                        announcementToSend = (Announcement)specificMessages.get(specificCounter.getAndIncrement());
                    } else {
                        if (!this.allMessages.isEmpty()) {
                            announcementToSend = this.allMessages.get(allCounter.getAndIncrement());
                            if (allCounter.get() >= this.allMessages.size()) {
                                allCounter.set(0);
                            }
                        }
                        specificCounter.set(0);
                    }
                }
                if (announcementToSend == null) continue;
                this.sendAnnouncement(targetPlayers, announcementToSend);
            }
        }, 20L * (long)this.interval, 20L * (long)this.interval);
        this.getLogger().info("Announcements scheduler started, running every " + this.interval + " seconds.");
    }

    private void sendAnnouncement(List<Player> players, Announcement announcement) {
        String type = announcement.type();
        String soundName = announcement.sound();
        List<String> lines = announcement.lines();
        String title = lines.isEmpty() ? "" : lines.get(0);
        String subtitle = lines.size() > 1 ? lines.get(1) : "";
        block11: for (Player player : players) {
            if (soundName != null && !soundName.isEmpty()) {
                try {
                    Sound soundEnum = Sound.valueOf((String)soundName.toUpperCase());
                    player.playSound(player.getLocation(), soundEnum, 1.0f, 1.0f);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid sound name in config.yml: " + soundName);
                }
            }
            String parsedTitle = this.parsePlaceholders(player, title);
            String parsedSubtitle = this.parsePlaceholders(player, subtitle);
            switch (type) {
                case "TITLE": {
                    player.sendTitle(parsedTitle, parsedSubtitle, 10, 70, 20);
                    continue block11;
                }
                case "ACTIONBAR": {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)parsedTitle));
                    continue block11;
                }
            }
            for (String line : lines) {
                String parsedLine = this.parsePlaceholders(player, this.prefix + line);
                player.sendMessage(parsedLine);
            }
        }
    }

    private String parsePlaceholders(Player player, String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String parsed = this.placeholderApiEnabled ? PlaceholderAPI.setPlaceholders((Player)player, (String)text) : text;
        return ChatColor.translateAlternateColorCodes((char)'&', (String)parsed);
    }

    public String getPrefix() {
        return this.prefix;
    }
}

