/*
 * Decompiled with CFR 0.152.
 */
package cydev.id.cyannouncer.bukkit.lib.configurate.loader;

import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;

public final class AtomicFiles {
    private static final int MAX_TRIES = 2;

    private AtomicFiles() {
    }

    public static Callable<BufferedWriter> atomicWriterFactory(Path path, Charset charset) {
        Objects.requireNonNull(path, "path");
        return () -> AtomicFiles.atomicBufferedWriter(path, charset);
    }

    public static BufferedWriter atomicBufferedWriter(Path path, Charset charset) throws IOException {
        path = path.toAbsolutePath();
        try {
            while (Files.isSymbolicLink(path)) {
                path = Files.readSymbolicLink(path);
            }
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
        Path writePath = AtomicFiles.temporaryPath(path.getParent(), path.getFileName().toString());
        if (Files.exists(path, new LinkOption[0])) {
            Files.copy(path, writePath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
        AtomicFiles.createDirectoriesIfNecessary(writePath.getParent());
        BufferedWriter output = Files.newBufferedWriter(writePath, charset, new OpenOption[0]);
        return new BufferedWriter(new AtomicFileWriter(writePath, path, output));
    }

    private static void createDirectoriesIfNecessary(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }

    private static Path temporaryPath(Path parent, String key) {
        String fileName = "." + System.nanoTime() + ThreadLocalRandom.current().nextInt() + Objects.requireNonNull(key, "key").replaceAll("[\\\\/:]", "-") + ".tmp";
        return parent.resolve(fileName);
    }

    private static class AtomicFileWriter
    extends FilterWriter {
        private final Path targetPath;
        private final Path writePath;

        protected AtomicFileWriter(Path writePath, Path targetPath, Writer wrapping) {
            super(wrapping);
            this.writePath = writePath;
            this.targetPath = targetPath;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                Files.move(this.writePath, this.targetPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AccessDeniedException ex) {
                for (int tries = 0; tries < 2; ++tries) {
                    try {
                        Thread.sleep(5 * tries);
                        Files.move(this.writePath, this.targetPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    catch (AccessDeniedException ex2) {
                        if (tries != 1) continue;
                        throw ex;
                    }
                    catch (InterruptedException exInterrupt) {
                        Thread.currentThread().interrupt();
                        throw ex;
                    }
                }
            }
        }
    }
}

