/*
 * Decompiled with CFR 0.152.
 */
package cydev.id.cyannouncer.bukkit.lib.configurate.serialize;

import cydev.id.cyannouncer.bukkit.lib.configurate.ConfigurationNode;
import cydev.id.cyannouncer.bukkit.lib.configurate.serialize.SerializationException;
import cydev.id.cyannouncer.bukkit.lib.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PathSerializer
implements TypeSerializer<Path> {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final PathSerializer INSTANCE = new PathSerializer();
    static final Class<Path> TYPE = Path.class;

    private PathSerializer() {
    }

    @Override
    public Path deserialize(Type type, ConfigurationNode node) throws SerializationException {
        if (node.isList()) {
            @Nullable List<String> elements = node.getList(String.class);
            if (elements == null || elements.isEmpty()) {
                return Paths.get(".", new String[0]);
            }
            if (elements.size() == 1) {
                return Paths.get(elements.get(0), new String[0]);
            }
            return Paths.get(elements.get(0), elements.subList(1, elements.size()).toArray(EMPTY_STRING_ARRAY));
        }
        if (node.isMap()) {
            throw new SerializationException("Paths must be a list of strings, or a single string");
        }
        @Nullable Object value = node.rawScalar();
        if (value == null) {
            throw new SerializationException("must have scalar value");
        }
        if (value instanceof URI) {
            return Paths.get((URI)value);
        }
        return Paths.get(value.toString(), new String[0]);
    }

    @Override
    public void serialize(Type type, @Nullable Path obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        if (node.isList()) {
            node.set(null);
            for (Path element : obj) {
                node.appendListNode().set(element.toString());
            }
        } else if (!obj.getFileSystem().equals(FileSystems.getDefault())) {
            node.set(URI.class, obj.toUri());
        } else {
            node.raw(obj.toString());
        }
    }
}

