/*
 * Decompiled with CFR 0.152.
 */
package cydev.id.cyannouncer.bukkit.lib.configurate.transformation;

import cydev.id.cyannouncer.bukkit.lib.configurate.ConfigurateException;
import cydev.id.cyannouncer.bukkit.lib.configurate.ConfigurationNode;
import cydev.id.cyannouncer.bukkit.lib.configurate.transformation.ConfigurationTransformation;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

class ChainedConfigurationTransformation
implements ConfigurationTransformation {
    private final ConfigurationTransformation[] transformations;

    ChainedConfigurationTransformation(ConfigurationTransformation[] transformations) {
        this.transformations = Arrays.copyOf(transformations, transformations.length);
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        for (ConfigurationTransformation transformation : this.transformations) {
            try {
                transformation.apply(node);
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }
}

