/*
 * Decompiled with CFR 0.152.
 */
package cydev.id.cyannouncer.velocity;

import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import cydev.id.cyannouncer.velocity.VelocityAnnouncer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class BroadcastCommand
implements SimpleCommand {
    private final VelocityAnnouncer plugin;

    public BroadcastCommand(VelocityAnnouncer plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length < 2) {
            invocation.source().sendMessage((Component)Component.text((String)"Usage: /vbroadcast <server1,server2,...|all> <message>", (TextColor)NamedTextColor.RED));
            return;
        }
        String targets = args[0];
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        TextComponent componentMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getPrefix() + message);
        if (targets.equalsIgnoreCase("all")) {
            this.plugin.getServer().sendMessage((Component)componentMessage);
            invocation.source().sendMessage((Component)Component.text((String)"Broadcast sent to all servers.", (TextColor)NamedTextColor.GREEN));
        } else {
            List<String> targetServers = Arrays.asList(targets.split(","));
            List allServerNames = this.plugin.getServer().getAllServers().stream().map(rs -> rs.getServerInfo().getName()).collect(Collectors.toList());
            for (String targetServer : targetServers) {
                if (allServerNames.contains(targetServer)) continue;
                invocation.source().sendMessage((Component)Component.text((String)("Error: Server '" + targetServer + "' not found."), (TextColor)NamedTextColor.RED));
                invocation.source().sendMessage((Component)Component.text((String)("Available servers: " + String.join((CharSequence)", ", allServerNames)), (TextColor)NamedTextColor.GRAY));
                return;
            }
            for (Player player : this.plugin.getServer().getAllPlayers()) {
                player.getCurrentServer().ifPresent(arg_0 -> BroadcastCommand.lambda$execute$1(targetServers, player, (Component)componentMessage, arg_0));
            }
            invocation.source().sendMessage((Component)Component.text((String)("Broadcast sent to servers: " + String.join((CharSequence)", ", targetServers)), (TextColor)NamedTextColor.GREEN));
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("announcer.broadcast");
    }

    private static /* synthetic */ void lambda$execute$1(List targetServers, Player player, Component componentMessage, ServerConnection serverConnection) {
        String serverName = serverConnection.getServerInfo().getName();
        if (targetServers.contains(serverName)) {
            player.sendMessage(componentMessage);
        }
    }
}

