/*
 * Decompiled with CFR 0.152.
 */
package cydev.id.cyannouncer.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.scheduler.ScheduledTask;
import cydev.id.cyannouncer.velocity.Announcement;
import cydev.id.cyannouncer.velocity.AnnouncerReloadCommand;
import cydev.id.cyannouncer.velocity.BroadcastCommand;
import cydev.id.cyannouncer.velocity.libs.bstats.velocity.Metrics;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

@Plugin(id="cyannouncervelocity", name="CyAnnouncerVelocity", version="1.0.2", description="An advanced, server-specific announcer plugin for Velocity.", authors={"cydev-id"})
public class VelocityAnnouncer {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private final Metrics.Factory metricsFactory;
    private ScheduledTask announcementTask;
    private List<Announcement> allMessages;
    private Map<String, List<Announcement>> serverSpecificMessages;
    private final Map<String, AtomicInteger> specificCounters = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, AtomicInteger> allCounters = new ConcurrentHashMap<String, AtomicInteger>();
    private String prefix;
    private int interval;
    private boolean isRandom = false;

    @Inject
    public VelocityAnnouncer(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        int pluginId = 27593;
        this.metricsFactory.make(this, pluginId);
        this.loadConfig();
        this.server.getCommandManager().register("vbroadcast", (Command)new BroadcastCommand(this), new String[0]);
        this.server.getCommandManager().register("announcer", (Command)new AnnouncerReloadCommand(this), new String[0]);
        this.logger.info("Successfully registered commands.");
        this.startAnnouncements();
    }

    public void loadConfig() {
        int targetConfigVersion = 2;
        File configFile = new File(this.dataDirectory.toFile(), "config.yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(configFile)).build();
        if (!configFile.exists()) {
            this.logger.info("No config.yml found, creating a new one...");
            this.saveDefaultConfigHelper();
        }
        try {
            CommentedConfigurationNode config = (CommentedConfigurationNode)loader.load();
            int currentVersion = ((CommentedConfigurationNode)config.node(new Object[]{"config-version"})).getInt(0);
            if (currentVersion < targetConfigVersion) {
                this.logger.warn("!!! DETECTED OUTDATED CONFIG (Version " + currentVersion + ") !!!");
                this.logger.warn("Backing up your old config to 'config.yml.old'...");
                File oldConfigFile = new File(this.dataDirectory.toFile(), "config.yml.old");
                if (oldConfigFile.exists()) {
                    oldConfigFile.delete();
                }
                loader = null;
                if (!configFile.renameTo(oldConfigFile)) {
                    this.logger.error("!!! FAILED TO BACK UP OLD CONFIG. Please do it manually! Aborting load.");
                    return;
                }
                this.saveDefaultConfigHelper();
                loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(configFile)).build();
                config = (CommentedConfigurationNode)loader.load();
                this.logger.info("Successfully loaded new config.yml (Version " + targetConfigVersion + ").");
                this.logger.info("Please transfer your old announcement lines from 'config.yml.old'.");
            }
            this.interval = ((CommentedConfigurationNode)config.node(new Object[]{"interval"})).getInt(60);
            this.prefix = ((CommentedConfigurationNode)config.node(new Object[]{"prefix"})).getString("&e[&l!&r&e] &r");
            this.isRandom = ((CommentedConfigurationNode)config.node(new Object[]{"settings", "random"})).getBoolean(false);
            this.allMessages = new ArrayList<Announcement>();
            this.serverSpecificMessages = new HashMap<String, List<Announcement>>();
            List announcementNodes = ((CommentedConfigurationNode)config.node(new Object[]{"announcements"})).childrenList();
            for (CommentedConfigurationNode node : announcementNodes) {
                List<String> servers = ((CommentedConfigurationNode)node.node(new Object[]{"servers"})).getList(String.class, Collections.emptyList());
                List<String> lines = ((CommentedConfigurationNode)node.node(new Object[]{"lines"})).getList(String.class, Collections.emptyList());
                String type = ((CommentedConfigurationNode)node.node(new Object[]{"type"})).getString("CHAT").toUpperCase();
                String sound = ((CommentedConfigurationNode)node.node(new Object[]{"sound"})).getString("");
                if (!servers.isEmpty() && !lines.isEmpty()) {
                    Announcement announcement = new Announcement(servers, lines, type, sound);
                    if (servers.contains("all")) {
                        this.allMessages.add(announcement);
                        continue;
                    }
                    for (String serverName : servers) {
                        this.serverSpecificMessages.computeIfAbsent(serverName, k -> new ArrayList()).add(announcement);
                    }
                    continue;
                }
                this.logger.warn("Skipping an announcement entry because 'servers' or 'lines' is empty.");
            }
            this.logger.info("Configuration loaded. Random Mode: " + this.isRandom);
            this.logger.info("Found " + this.allMessages.size() + " global announcements and messages for " + this.serverSpecificMessages.size() + " specific servers.");
            this.specificCounters.clear();
            this.allCounters.clear();
        }
        catch (Exception e) {
            this.logger.error("Failed to load the configuration!", (Throwable)e);
        }
    }

    private void saveDefaultConfigHelper() {
        block9: {
            File configFile = new File(this.dataDirectory.toFile(), "config.yml");
            try {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
                if (configFile.exists()) break block9;
                try (InputStream defaultConfig = this.getClass().getClassLoader().getResourceAsStream("config.yml");){
                    if (defaultConfig != null) {
                        Files.copy(defaultConfig, configFile.toPath(), new CopyOption[0]);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to create the default configuration file!", (Throwable)e);
            }
        }
    }

    public void startAnnouncements() {
        if (this.announcementTask != null) {
            this.announcementTask.cancel();
        }
        if (this.allMessages.isEmpty() && this.serverSpecificMessages.isEmpty() || this.interval <= 0) {
            this.logger.warn("Announcements are disabled (no messages found or invalid interval).");
            return;
        }
        this.announcementTask = this.server.getScheduler().buildTask((Object)this, () -> {
            if (this.server.getPlayerCount() == 0) {
                return;
            }
            Map<String, List<Player>> playersByServer = this.server.getAllPlayers().stream().filter(p -> p.getCurrentServer().isPresent()).collect(Collectors.groupingBy(p -> ((ServerConnection)p.getCurrentServer().get()).getServerInfo().getName()));
            for (String serverName : playersByServer.keySet()) {
                List<Player> targetPlayers = playersByServer.get(serverName);
                List specificMessages = this.serverSpecificMessages.getOrDefault(serverName, Collections.emptyList());
                Announcement announcementToSend = null;
                if (this.isRandom) {
                    ArrayList<Announcement> availableMessages = new ArrayList<Announcement>(this.allMessages);
                    availableMessages.addAll(specificMessages);
                    if (!availableMessages.isEmpty()) {
                        announcementToSend = (Announcement)availableMessages.get(new Random().nextInt(availableMessages.size()));
                    }
                } else {
                    AtomicInteger specificCounter = this.specificCounters.computeIfAbsent(serverName, k -> new AtomicInteger(0));
                    AtomicInteger allCounter = this.allCounters.computeIfAbsent(serverName, k -> new AtomicInteger(0));
                    if (!specificMessages.isEmpty() && specificCounter.get() < specificMessages.size()) {
                        announcementToSend = (Announcement)specificMessages.get(specificCounter.getAndIncrement());
                    } else {
                        if (!this.allMessages.isEmpty()) {
                            announcementToSend = this.allMessages.get(allCounter.getAndIncrement());
                            if (allCounter.get() >= this.allMessages.size()) {
                                allCounter.set(0);
                            }
                        }
                        specificCounter.set(0);
                    }
                }
                if (announcementToSend == null) continue;
                this.sendAnnouncement(targetPlayers, announcementToSend);
            }
        }).repeat(Duration.ofSeconds(this.interval)).schedule();
        this.logger.info("Advanced announcements scheduler started, running every " + this.interval + " seconds.");
    }

    private void sendAnnouncement(List<Player> players, Announcement announcement) {
        String type = announcement.type();
        String soundName = announcement.sound();
        List<String> lines = announcement.lines();
        String title = lines.isEmpty() ? "" : lines.get(0);
        String subtitle = lines.size() > 1 ? lines.get(1) : "";
        Title.Times times = Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3500L), (Duration)Duration.ofMillis(1000L));
        block11: for (Player player : players) {
            if (soundName != null && !soundName.isEmpty()) {
                try {
                    String minecraftKey = soundName.toLowerCase(Locale.ROOT).replace('_', '.');
                    Sound sound = Sound.sound((Key)Key.key((String)"minecraft", (String)minecraftKey), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f);
                    player.playSound(sound);
                }
                catch (Exception e) {
                    this.logger.warn("Invalid sound name or format in config.yml: " + soundName);
                }
            }
            Component parsedTitle = this.deserialize(this.replacePlaceholders(title, player));
            Component parsedSubtitle = this.deserialize(this.replacePlaceholders(subtitle, player));
            switch (type) {
                case "TITLE": {
                    Title titleObj = Title.title((Component)parsedTitle, (Component)parsedSubtitle, (Title.Times)times);
                    player.showTitle(titleObj);
                    continue block11;
                }
                case "ACTIONBAR": {
                    player.sendActionBar(parsedTitle);
                    continue block11;
                }
            }
            for (String line : lines) {
                Component parsedLine = this.deserialize(this.replacePlaceholders(this.prefix + line, player));
                player.sendMessage(parsedLine);
            }
        }
    }

    private String replacePlaceholders(String text, Player player) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String serverName = "unknown";
        int serverOnline = 0;
        if (player.getCurrentServer().isPresent()) {
            serverName = ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName();
            serverOnline = ((ServerConnection)player.getCurrentServer().get()).getServer().getPlayersConnected().size();
        }
        return text.replace("%player_name%", player.getUsername()).replace("%server_name%", serverName).replace("%proxy_online%", String.valueOf(this.server.getPlayerCount())).replace("%server_online%", String.valueOf(serverOnline)).replace("%ping%", String.valueOf(player.getPing()));
    }

    private Component deserialize(String text) {
        return LegacyComponentSerializer.legacyAmpersand().deserialize(text);
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

