/*
 * Decompiled with CFR 0.152.
 */
package cydev.id.cyannouncer.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.scheduler.ScheduledTask;
import cydev.id.cyannouncer.velocity.Announcement;
import cydev.id.cyannouncer.velocity.AnnouncerReloadCommand;
import cydev.id.cyannouncer.velocity.BroadcastCommand;
import cydev.id.cyannouncer.velocity.libs.bstats.velocity.Metrics;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

@Plugin(id="cyannouncervelocity", name="CyAnnouncerVelocity", version="1.0.0", description="An advanced, server-specific announcer plugin for Velocity.", authors={"cydev-id"})
public class VelocityAnnouncer {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private final Metrics.Factory metricsFactory;
    private ScheduledTask announcementTask;
    private List<Announcement> allMessages;
    private Map<String, List<Announcement>> serverSpecificMessages;
    private final Map<String, AtomicInteger> specificCounters = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, AtomicInteger> allCounters = new ConcurrentHashMap<String, AtomicInteger>();
    private String prefix;
    private int interval;

    @Inject
    public VelocityAnnouncer(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        int pluginId = 27593;
        this.metricsFactory.make(this, pluginId);
        this.loadConfig();
        this.server.getCommandManager().register("vbroadcast", (Command)new BroadcastCommand(this), new String[0]);
        this.server.getCommandManager().register("announcer", (Command)new AnnouncerReloadCommand(this), new String[0]);
        this.logger.info("Successfully registered commands.");
        this.startAnnouncements();
    }

    public void loadConfig() {
        File configFile = new File(this.dataDirectory.toFile(), "config.yml");
        if (!configFile.exists()) {
            try {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
                try (InputStream defaultConfig = this.getClass().getClassLoader().getResourceAsStream("config.yml");){
                    if (defaultConfig != null) {
                        Files.copy(defaultConfig, configFile.toPath(), new CopyOption[0]);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to create the default configuration file!", (Throwable)e);
                return;
            }
        }
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(configFile)).build();
        try {
            CommentedConfigurationNode config = (CommentedConfigurationNode)loader.load();
            this.interval = ((CommentedConfigurationNode)config.node(new Object[]{"interval"})).getInt(60);
            this.prefix = ((CommentedConfigurationNode)config.node(new Object[]{"prefix"})).getString("&e[&l!&r&e] &r");
            this.allMessages = new ArrayList<Announcement>();
            this.serverSpecificMessages = new HashMap<String, List<Announcement>>();
            List announcementNodes = ((CommentedConfigurationNode)config.node(new Object[]{"announcements"})).childrenList();
            for (CommentedConfigurationNode node : announcementNodes) {
                List<String> servers = ((CommentedConfigurationNode)node.node(new Object[]{"servers"})).getList(String.class, Collections.emptyList());
                List<String> lines = ((CommentedConfigurationNode)node.node(new Object[]{"lines"})).getList(String.class, Collections.emptyList());
                if (!servers.isEmpty() && !lines.isEmpty()) {
                    Announcement announcement = new Announcement(servers, lines);
                    if (servers.contains("all")) {
                        this.allMessages.add(announcement);
                        continue;
                    }
                    for (String serverName : servers) {
                        this.serverSpecificMessages.computeIfAbsent(serverName, k -> new ArrayList()).add(announcement);
                    }
                    continue;
                }
                this.logger.warn("Skipping an announcement entry because 'servers' or 'lines' is empty.");
            }
            this.logger.info("Configuration loaded. Found " + this.allMessages.size() + " global announcements and messages for " + this.serverSpecificMessages.size() + " specific servers.");
            this.specificCounters.clear();
            this.allCounters.clear();
        }
        catch (Exception e) {
            this.logger.error("Failed to load the configuration!", (Throwable)e);
        }
    }

    public void startAnnouncements() {
        if (this.announcementTask != null) {
            this.announcementTask.cancel();
        }
        if (this.allMessages.isEmpty() && this.serverSpecificMessages.isEmpty() || this.interval <= 0) {
            this.logger.warn("Announcements are disabled (no messages found or invalid interval).");
            return;
        }
        this.announcementTask = this.server.getScheduler().buildTask((Object)this, () -> {
            if (this.server.getPlayerCount() == 0) {
                return;
            }
            Map<String, List<Player>> playersByServer = this.server.getAllPlayers().stream().filter(p -> p.getCurrentServer().isPresent()).collect(Collectors.groupingBy(p -> ((ServerConnection)p.getCurrentServer().get()).getServerInfo().getName()));
            for (String serverName : playersByServer.keySet()) {
                List specificMessages = this.serverSpecificMessages.getOrDefault(serverName, Collections.emptyList());
                AtomicInteger specificCounter = this.specificCounters.computeIfAbsent(serverName, k -> new AtomicInteger(0));
                AtomicInteger allCounter = this.allCounters.computeIfAbsent(serverName, k -> new AtomicInteger(0));
                Announcement announcementToSend = null;
                if (!specificMessages.isEmpty() && specificCounter.get() < specificMessages.size()) {
                    announcementToSend = (Announcement)specificMessages.get(specificCounter.getAndIncrement());
                } else {
                    if (!this.allMessages.isEmpty()) {
                        announcementToSend = this.allMessages.get(allCounter.getAndIncrement());
                        if (allCounter.get() >= this.allMessages.size()) {
                            allCounter.set(0);
                        }
                    }
                    specificCounter.set(0);
                }
                if (announcementToSend == null) continue;
                List<Player> targetPlayers = playersByServer.get(serverName);
                for (String line : announcementToSend.lines()) {
                    TextComponent finalLine = LegacyComponentSerializer.legacyAmpersand().deserialize(this.prefix + line);
                    for (Player player : targetPlayers) {
                        player.sendMessage((Component)finalLine);
                    }
                }
            }
        }).repeat(Duration.ofSeconds(this.interval)).schedule();
        this.logger.info("Advanced announcements scheduler started, running every " + this.interval + " seconds.");
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

