/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.recipeBuilders.modifiers;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.item.ItemStack;
import turniplabs.halplibe.helper.RecipeBuilder;
import turniplabs.halplibe.mixin.accessors.WeightedRandomBagAccessor;
import turniplabs.halplibe.mixin.accessors.WeightedRandomBagEntryAccessor;

public class TrommelModifier {
    private final WeightedRandomBag<WeightedRandomLootObject> trommelEntry;
    private final String key;
    private final String namespace;

    public TrommelModifier(String namespace, String key) {
        this.key = key;
        this.namespace = namespace;
        this.trommelEntry = (WeightedRandomBag)Objects.requireNonNull((RecipeEntryBase)RecipeBuilder.getRecipeGroup(namespace, "trommel", new RecipeSymbol(Blocks.TROMMEL_ACTIVE.getDefaultStack())).getItem(key), "Requested recipe " + namespace + ":trommel/" + key + " does not exist!").getOutput();
    }

    public void deleteRecipe() {
        RecipeGroup<?> recipeGroup = RecipeBuilder.getRecipeGroup(this.namespace, "trommel", new RecipeSymbol(Blocks.TROMMEL_ACTIVE.getDefaultStack()));
        recipeGroup.unregister(this.key);
    }

    public TrommelModifier addEntry(WeightedRandomLootObject lootObject, double weight) {
        this.trommelEntry.addEntry((Object)lootObject, weight);
        return this;
    }

    public TrommelModifier removeEntries(ItemStack outputStack) {
        ArrayList outputs = new ArrayList(this.trommelEntry.getEntriesWithWeights());
        for (WeightedRandomBag.Entry object : outputs) {
            WeightedRandomLootObject weightedObject = (WeightedRandomLootObject)object.getObject();
            if (!weightedObject.getItemStack().isItemEqual(outputStack)) continue;
            ((WeightedRandomBagAccessor)this.trommelEntry).getRawEntries().remove(object);
        }
        this.recalculateWeights();
        return this;
    }

    public TrommelModifier removeEntry(ItemStack outputStack, double weight) {
        ArrayList outputs = new ArrayList(this.trommelEntry.getEntriesWithWeights());
        for (WeightedRandomBag.Entry object : outputs) {
            WeightedRandomLootObject weightedObject = (WeightedRandomLootObject)object.getObject();
            if (!weightedObject.getItemStack().isItemEqual(outputStack) || weight != object.getWeight()) continue;
            ((WeightedRandomBagAccessor)this.trommelEntry).getRawEntries().remove(object);
            break;
        }
        this.recalculateWeights();
        return this;
    }

    public TrommelModifier setWeight(ItemStack outputStack, double oldWeight, double newWeight) {
        ArrayList outputs = new ArrayList(this.trommelEntry.getEntriesWithWeights());
        for (WeightedRandomBag.Entry object : outputs) {
            WeightedRandomLootObject weightedObject = (WeightedRandomLootObject)object.getObject();
            if (!weightedObject.getItemStack().isItemEqual(outputStack) || oldWeight != object.getWeight()) continue;
            ((WeightedRandomBagEntryAccessor)object).setWeight(newWeight);
            break;
        }
        this.recalculateWeights();
        return this;
    }

    public TrommelModifier setWeights(ItemStack outputStack, double newWeight) {
        ArrayList outputs = new ArrayList(this.trommelEntry.getEntriesWithWeights());
        for (WeightedRandomBag.Entry object : outputs) {
            WeightedRandomLootObject weightedObject = (WeightedRandomLootObject)object.getObject();
            if (!weightedObject.getItemStack().isItemEqual(outputStack)) continue;
            ((WeightedRandomBagEntryAccessor)object).setWeight(newWeight);
        }
        this.recalculateWeights();
        return this;
    }

    protected void recalculateWeights() {
        double weight = 0.0;
        for (WeightedRandomBag.Entry object : this.trommelEntry.getEntriesWithWeights()) {
            weight += object.getWeight();
        }
        ((WeightedRandomBagAccessor)this.trommelEntry).setAccumulatedWeight(weight);
    }
}

