/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import turniplabs.halplibe.HalpLibe;

public class ConfigHandler {
    private static final String CONFIG_DIRECTORY = FabricLoader.getInstance().getGameDir().toString() + "/config/";
    private final Properties defaultProperties;
    private final Properties properties;
    private String configFileName = "";

    public ConfigHandler(String modID, Properties defaultProperties) {
        this.configFileName = modID + ".cfg";
        this.defaultProperties = defaultProperties;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)defaultProperties);
        HalpLibe.LOGGER.info("Config file name: " + this.properties);
        File configFile = new File(this.getFilePath());
        HalpLibe.LOGGER.info("Config file path: " + configFile.getAbsolutePath());
        try {
            if (!configFile.exists()) {
                HalpLibe.LOGGER.info("Config file does not exist. Creating...");
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
                ConfigHandler.writeDefaultConfig(configFile, this.defaultProperties);
            } else {
                ConfigHandler.loadConfig(configFile, this.properties);
                ConfigHandler.updateConfig(configFile, this.properties);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeDefaultConfig(File configFile, Properties properties) {
        HalpLibe.LOGGER.info("Writing default config to " + configFile.getAbsolutePath());
        try (FileOutputStream output = new FileOutputStream(configFile);){
            properties.store(output, "Default config values");
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updateConfig(File configFile, Properties properties) {
        HalpLibe.LOGGER.info("Updating config at " + configFile.getAbsolutePath());
        try (FileOutputStream output = new FileOutputStream(configFile);){
            properties.store(output, "Updated config values");
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig(File configFile, Properties properties) {
        try (FileInputStream input = new FileInputStream(configFile);){
            properties.load(input);
            ((InputStream)input).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFilePath() {
        return CONFIG_DIRECTORY + this.configFileName;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public Integer getInt(String key) {
        return Integer.parseInt(this.properties.getProperty(key));
    }

    public Boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    public void writeDefaultConfig() {
        File configFile = new File(this.getFilePath());
        ConfigHandler.writeDefaultConfig(configFile, this.defaultProperties);
    }

    public void loadConfig() {
        File configFile = new File(this.getFilePath());
        ConfigHandler.loadConfig(configFile, this.properties);
    }

    public void updateConfig() {
        File configFile = new File(this.getFilePath());
        ConfigHandler.updateConfig(configFile, this.properties);
    }
}

