/*
 * Decompiled with CFR 0.152.
 */
package gungun974.uselessnumerical;

import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.Tag;
import gungun974.uselessnumerical.MinecraftIdsConflict;
import gungun974.uselessnumerical.UselessNumericalMod;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.Item;
import net.minecraft.core.net.PropertyManager;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;

public class MinecraftIdsConfiguration {
    private static MinecraftIdsConfiguration instance;
    private static boolean hasLoadedInstance;
    private final Map<NamespaceID, Integer> localBlockMap = new LinkedHashMap<NamespaceID, Integer>();
    private final Map<NamespaceID, Integer> localItemsMap = new LinkedHashMap<NamespaceID, Integer>();

    public static synchronized MinecraftIdsConfiguration getInstance() {
        if (instance == null) {
            instance = new MinecraftIdsConfiguration();
        }
        if (!hasLoadedInstance) {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                instance.loadServerInstanceConfiguration();
            } else {
                instance.loadClientInstanceConfiguration();
            }
            hasLoadedInstance = true;
        }
        return instance;
    }

    public boolean hasWorldConfiguration(File saveDir) {
        if (!saveDir.exists()) {
            return false;
        }
        File worldLevelDat = new File(saveDir, "uselessNumericalSave.dat");
        if (worldLevelDat.exists()) {
            return true;
        }
        worldLevelDat = new File(saveDir, "uselessNumericalSave.dat_old");
        return worldLevelDat.exists();
    }

    @Environment(value=EnvType.CLIENT)
    public void loadClientInstanceConfiguration() {
        CompoundTag nbtRoot = null;
        File instanceDir = Minecraft.getMinecraft().getMinecraftDir();
        try {
            if (!instanceDir.exists()) {
                throw new IOException();
            }
            File worldLevelDat = new File(instanceDir, "uselessNumericalInstance.dat");
            if (worldLevelDat.exists()) {
                nbtRoot = NbtIo.readCompressed((InputStream)Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
            } else {
                worldLevelDat = new File(instanceDir, "uselessNumericalInstance.dat_old");
                if (worldLevelDat.exists()) {
                    nbtRoot = NbtIo.readCompressed((InputStream)Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                }
            }
            if (nbtRoot != null) {
                this.loadNBTData(nbtRoot);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Environment(value=EnvType.SERVER)
    public void loadServerInstanceConfiguration() {
        String lName;
        PropertyManager propertyManager = new PropertyManager(new File("server.properties"));
        String[] args = FabricLoader.getInstance().getLaunchArguments(true);
        String world = null;
        int pointer = 0;
        while (pointer < args.length) {
            if (args[pointer].equals("--world")) {
                try {
                    world = args[pointer + 1];
                    ++pointer;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++pointer;
                continue;
            }
            ++pointer;
        }
        String string = lName = world == null ? propertyManager.getStringProperty("level-name", "world") : world;
        if (instance.hasWorldConfiguration(new File(lName))) {
            instance.loadWorldConfiguration(new File(lName));
            UselessNumericalMod.LOGGER.info("Load \"{}\" ids configuration", (Object)lName);
        }
    }

    public void loadWorldConfiguration(File saveDir) {
        CompoundTag nbtRoot = null;
        try {
            if (!saveDir.exists()) {
                throw new IOException();
            }
            File worldLevelDat = new File(saveDir, "uselessNumericalSave.dat");
            if (worldLevelDat.exists()) {
                nbtRoot = NbtIo.readCompressed((InputStream)Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
            } else {
                worldLevelDat = new File(saveDir, "uselessNumericalSave.dat_old");
                if (worldLevelDat.exists()) {
                    nbtRoot = NbtIo.readCompressed((InputStream)Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                }
            }
            if (nbtRoot != null) {
                this.loadNBTData(nbtRoot);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadNBTData(CompoundTag nbtRoot) {
        CompoundTag blockTags = nbtRoot.getCompound("Blocks");
        this.localBlockMap.clear();
        for (Map.Entry entry : ((Map)blockTags.getValue()).entrySet()) {
            Tag tag = (Tag)entry.getValue();
            if (!(tag instanceof IntTag)) continue;
            int id = (Integer)((IntTag)tag).getValue();
            try {
                NamespaceID namespaceID = NamespaceID.getPermanent((String)((String)entry.getKey()));
                this.localBlockMap.put(namespaceID, id);
            }
            catch (HardIllegalArgumentException namespaceID) {}
        }
        CompoundTag itemTags = nbtRoot.getCompound("Items");
        this.localItemsMap.clear();
        for (Map.Entry entry : ((Map)itemTags.getValue()).entrySet()) {
            Tag tag = (Tag)entry.getValue();
            if (!(tag instanceof IntTag)) continue;
            int id = (Integer)((IntTag)tag).getValue();
            try {
                NamespaceID namespaceID = NamespaceID.getPermanent((String)((String)entry.getKey()));
                this.localItemsMap.put(namespaceID, id);
            }
            catch (HardIllegalArgumentException hardIllegalArgumentException) {}
        }
    }

    public void saveInstanceConfiguration() {
        CompoundTag rootTag = this.createNBTData();
        try {
            File levelDatNew = new File(Minecraft.getMinecraft().getMinecraftDir(), "uselessNumericalInstance.dat_new");
            File levelDatOld = new File(Minecraft.getMinecraft().getMinecraftDir(), "uselessNumericalInstance.dat_old");
            File levelDat = new File(Minecraft.getMinecraft().getMinecraftDir(), "uselessNumericalInstance.dat");
            NbtIo.writeCompressed((CompoundTag)rootTag, (OutputStream)Files.newOutputStream(levelDatNew.toPath(), new OpenOption[0]));
            if (levelDatOld.exists()) {
                levelDatOld.delete();
            }
            levelDat.renameTo(levelDatOld);
            if (levelDat.exists()) {
                levelDat.delete();
            }
            levelDatNew.renameTo(levelDat);
            if (levelDatNew.exists()) {
                levelDatNew.delete();
            }
        }
        catch (Exception exception) {
            UselessNumericalMod.LOGGER.error("Failed to save ids data to disk!", (Throwable)exception);
        }
    }

    public void saveWorldConfiguration(File saveDir) {
        CompoundTag rootTag = this.createNBTData();
        try {
            File levelDatNew = new File(saveDir, "uselessNumericalSave.dat_new");
            File levelDatOld = new File(saveDir, "uselessNumericalSave.dat_old");
            File levelDat = new File(saveDir, "uselessNumericalSave.dat");
            NbtIo.writeCompressed((CompoundTag)rootTag, (OutputStream)Files.newOutputStream(levelDatNew.toPath(), new OpenOption[0]));
            if (levelDatOld.exists()) {
                levelDatOld.delete();
            }
            levelDat.renameTo(levelDatOld);
            if (levelDat.exists()) {
                levelDat.delete();
            }
            levelDatNew.renameTo(levelDat);
            if (levelDatNew.exists()) {
                levelDatNew.delete();
            }
        }
        catch (Exception exception) {
            UselessNumericalMod.LOGGER.error("Failed to save ids data to disk!", (Throwable)exception);
        }
    }

    @NotNull
    public CompoundTag createNBTData() {
        CompoundTag rootTag = new CompoundTag();
        CompoundTag blockTags = new CompoundTag();
        for (Map.Entry<NamespaceID, Integer> entry : this.localBlockMap.entrySet()) {
            if (!Blocks.blockMap.containsKey(entry.getKey())) continue;
            blockTags.putInt(entry.getKey().toString(), entry.getValue().intValue());
        }
        rootTag.putCompound("Blocks", blockTags);
        CompoundTag itemTags = new CompoundTag();
        for (Map.Entry<NamespaceID, Integer> entry : this.localItemsMap.entrySet()) {
            if (!Item.itemsMap.containsKey(entry.getKey())) continue;
            itemTags.putInt(entry.getKey().toString(), entry.getValue().intValue());
        }
        rootTag.putCompound("Items", itemTags);
        return rootTag;
    }

    public int getNumericalIdForBlock(NamespaceID id) {
        return this.localBlockMap.getOrDefault(id, -1);
    }

    public void setNumericalIdForBlock(NamespaceID id, int numericalId) {
        this.localBlockMap.put(id, numericalId);
    }

    public int generateNumericalIdForBlock(NamespaceID id, int preferredNumericalId) {
        int attributedNumericalId = this.getNumericalIdForBlock(id);
        if (attributedNumericalId != -1) {
            return attributedNumericalId;
        }
        int numericalId = preferredNumericalId;
        while (this.localBlockMap.containsValue(numericalId)) {
            ++numericalId;
        }
        this.setNumericalIdForBlock(id, numericalId);
        return numericalId;
    }

    public int getNumericalIdForItem(NamespaceID id) {
        return this.localItemsMap.getOrDefault(id, -1);
    }

    public void setNumericalIdForItem(NamespaceID id, int numericalId) {
        this.localItemsMap.put(id, numericalId);
    }

    public int generateNumericalIdForItem(NamespaceID id, int preferredNumericalId) {
        if (preferredNumericalId < Blocks.blocksList.length) {
            this.setNumericalIdForItem(id, preferredNumericalId);
            return preferredNumericalId;
        }
        int attributedNumericalId = this.getNumericalIdForItem(id);
        if (attributedNumericalId != -1) {
            return attributedNumericalId;
        }
        int numericalId = preferredNumericalId;
        while (this.localItemsMap.containsValue(numericalId)) {
            ++numericalId;
        }
        this.setNumericalIdForItem(id, numericalId);
        return numericalId;
    }

    public MinecraftIdsConflict checkConflictWithInstance(boolean ignoreMissing) {
        int loadedId;
        Object conflict;
        if (!ignoreMissing) {
            boolean missing = false;
            LinkedHashMap<NamespaceID, Integer> missingLocalBlockMap = new LinkedHashMap<NamespaceID, Integer>();
            LinkedHashMap<NamespaceID, Integer> missingLocalItemsMap = new LinkedHashMap<NamespaceID, Integer>();
            for (Map.Entry<NamespaceID, Integer> block : this.localBlockMap.entrySet()) {
                if (Blocks.blockMap.containsKey(block.getKey())) continue;
                missing = true;
                missingLocalBlockMap.put(block.getKey(), block.getValue());
            }
            for (Map.Entry<NamespaceID, Integer> item : this.localItemsMap.entrySet()) {
                if (Item.itemsMap.containsKey(item.getKey())) continue;
                missing = true;
                missingLocalItemsMap.put(item.getKey(), item.getValue());
            }
            if (missing) {
                conflict = MinecraftIdsConflict.MISSING;
                ((MinecraftIdsConflict)((Object)conflict)).localBlockMap = missingLocalBlockMap;
                ((MinecraftIdsConflict)((Object)conflict)).localItemsMap = missingLocalItemsMap;
                return conflict;
            }
        }
        boolean needRestart = false;
        LinkedHashMap<NamespaceID, Integer> differentLocalBlockMap = new LinkedHashMap<NamespaceID, Integer>();
        LinkedHashMap<NamespaceID, Integer> differentLocalItemsMap = new LinkedHashMap<NamespaceID, Integer>();
        for (Map.Entry<NamespaceID, Integer> block : this.localBlockMap.entrySet()) {
            loadedId = instance.getNumericalIdForBlock(block.getKey());
            if (loadedId == -1 || loadedId == block.getValue()) continue;
            needRestart = true;
            differentLocalBlockMap.put(block.getKey(), block.getValue());
        }
        for (Map.Entry<NamespaceID, Integer> item : this.localItemsMap.entrySet()) {
            loadedId = instance.getNumericalIdForItem(item.getKey());
            if (loadedId == -1 || loadedId == item.getValue()) continue;
            needRestart = true;
            differentLocalItemsMap.put(item.getKey(), item.getValue());
        }
        if (needRestart) {
            conflict = MinecraftIdsConflict.NEED_RESTART;
            ((MinecraftIdsConflict)((Object)conflict)).localBlockMap = differentLocalBlockMap;
            ((MinecraftIdsConflict)((Object)conflict)).localItemsMap = differentLocalItemsMap;
            return conflict;
        }
        return MinecraftIdsConflict.NONE;
    }
}

