/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.gui.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScreenHudDesigner;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.BTWailaClient;
import toufoumaster.btwaila.demo.DemoManager;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.gui.components.WailaTextComponent;

public class BaseInfoComponent
extends WailaTextComponent {
    private final int topPadding = 4;

    public BaseInfoComponent(String key, Layout layout) {
        super(key, 24, layout);
    }

    public int getAnchorY(ComponentAnchor anchor) {
        if (anchor.yPosition == 0.0f && anchor != ComponentAnchor.TOP_CENTER) {
            return (int)(anchor.yPosition * (float)this.getYSize(Minecraft.getMinecraft())) + 4;
        }
        return (int)(anchor.yPosition * (float)this.getYSize(this.minecraft));
    }

    public int getYSize(Minecraft mc) {
        if (!(mc.currentScreen instanceof ScreenHudDesigner) && !this.isVisible(mc)) {
            return 0;
        }
        return this.height();
    }

    public boolean isVisible(Minecraft minecraft) {
        return minecraft.gameSettings.immersiveMode.drawHotbar();
    }

    @Override
    public void renderPost(Minecraft minecraft, HudIngame HudIngame2, int xScreenSize, int yScreenSize, float f) {
        this.addOffY(4);
        HitResult hitResult = minecraft.objectMouseOver;
        if (hitResult == null) {
            return;
        }
        if (hitResult.hitType == HitResult.HitType.TILE) {
            Block block = minecraft.currentWorld.getBlock(hitResult.x, hitResult.y, hitResult.z);
            int meta = minecraft.currentWorld.getBlockMetadata(hitResult.x, hitResult.y, hitResult.z);
            ItemStack[] drops = null;
            if (block != null) {
                drops = block.getBreakResult((World)minecraft.currentWorld, EnumDropCause.PICK_BLOCK, hitResult.x, hitResult.y, hitResult.z, minecraft.currentWorld.getBlockMetadata(hitResult.x, hitResult.y, hitResult.z), null);
            }
            this.baseBlockInfo(block, meta, drops);
        } else if (hitResult.hitType == HitResult.HitType.ENTITY) {
            this.baseEntityInfo(hitResult.entity);
        }
    }

    @Override
    public void renderPreviewPost(Minecraft minecraft, Gui gui, Layout layout, int xScreenSize, int yScreenSize) {
        this.addOffY(4);
        Block<?> block = DemoManager.getCurrentEntry().block;
        int meta = DemoManager.getCurrentEntry().meta;
        ItemStack[] drops = DemoManager.getCurrentEntry().drops;
        Entity entity = DemoManager.getCurrentEntry().entity;
        if (block != null) {
            this.baseBlockInfo(block, meta, drops);
        } else if (entity != null) {
            this.baseEntityInfo(entity);
        }
    }

    protected void baseBlockInfo(Block<?> block, int blockMetadata, ItemStack[] blockDrops) {
        if (!((Boolean)this.modSettings().bTWaila$getBlockTooltips().value).booleanValue()) {
            return;
        }
        if (this.minecraft.font == null) {
            return;
        }
        ItemStack renderItem = new ItemStack(block, 1, blockMetadata);
        if (blockDrops != null && blockDrops.length > 0) {
            renderItem = blockDrops[0];
        }
        String languageKey = renderItem.getItemKey();
        String blockName = BTWaila.translator.translateNameKey(languageKey);
        String blockDesc = BTWaila.translator.translateDescKey(languageKey);
        String blockSource = "Minecraft";
        for (String modId : BTWailaClient.modIds.keySet()) {
            if (!languageKey.contains(modId)) continue;
            blockSource = BTWailaClient.modIds.get(modId);
        }
        String idString = block.id() + ":" + blockMetadata;
        if (((Boolean)this.modSettings().bTWaila$getShowBlockId().value).booleanValue()) {
            blockName = blockName + " " + idString;
        }
        this.drawStringJustified(blockName, 0, this.getXSize(this.minecraft), 0xFFFFFF);
        this.drawStringJustified(blockSource, 0, this.getXSize(this.minecraft), 0x7F7FFF);
        if (((Boolean)this.modSettings().bTWaila$getShowBlockDesc().value).booleanValue()) {
            this.drawStringJustified(blockDesc, 0, this.getXSize(this.minecraft), 0xAFAFAF);
        }
    }

    protected void baseEntityInfo(Entity entity) {
        if (!((Boolean)this.modSettings().bTWaila$getEntityTooltips().value).booleanValue()) {
            return;
        }
        boolean isLivingEntity = entity instanceof Mob;
        Mob Mob2 = isLivingEntity ? (Mob)entity : null;
        int color = 0xFFFFFF;
        if (isLivingEntity) {
            color = 0x7FFF7F;
            if (entity instanceof MobMonster) {
                color = 0xFF7F7F;
            } else if (entity instanceof Player) {
                color = Mob2.chatColor;
            }
        }
        this.drawStringJustified(AdvancedInfoComponent.getEntityName(entity), 0, this.getXSize(this.minecraft), color);
    }
}

